/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A general purpose tuple.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Tuple original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Tuple.class)
public class Tuple {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Tuple that = (Tuple) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Tuple> __TYPE_ARG = new TypeArg<>(    obj -> new Tuple((io.vertx.sqlclient.Tuple) obj),
    Tuple::getDelegate
  );

  private final io.vertx.sqlclient.Tuple delegate;
  
  public Tuple(io.vertx.sqlclient.Tuple delegate) {
    this.delegate = delegate;
  }

  public Tuple(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Tuple)delegate;
  }

  public io.vertx.sqlclient.Tuple getDelegate() {
    return delegate;
  }

  /**
   * @return a new empty tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple tuple() { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.tuple());
    return ret;
  }

  /**
   * Wrap the provided <code>list</code> with a tuple.
   * <br/>
   * The list is not copied and is used as store for tuple elements.
   * @param list 
   * @return the list wrapped as a tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple wrap(List<java.lang.Object> list) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.wrap(list));
    return ret;
  }

  /**
   * Create a tuple of one element.
   * @param elt1 the first value
   * @return the tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple of(java.lang.Object elt1) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1));
    return ret;
  }

  /**
   * Create a tuple of two elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @return the tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2));
    return ret;
  }

  /**
   * Create a tuple of three elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @return the tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3));
    return ret;
  }

  /**
   * Create a tuple of four elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @return the tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3, java.lang.Object elt4) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4));
    return ret;
  }

  /**
   * Create a tuple of five elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @param elt5 the fifth value
   * @return the tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3, java.lang.Object elt4, java.lang.Object elt5) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4, elt5));
    return ret;
  }

  /**
   * Create a tuple of six elements.
   * @param elt1 the first value
   * @param elt2 the second valueg
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @param elt5 the fifth value
   * @param elt6 the sixth value
   * @return the tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple of(java.lang.Object elt1, java.lang.Object elt2, java.lang.Object elt3, java.lang.Object elt4, java.lang.Object elt5, java.lang.Object elt6) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4, elt5, elt6));
    return ret;
  }

  /**
   * Create a tuple with the provided <code>elements</code> list.
   * <p/>
   * The <code>elements</code> list is not modified.
   * @param elements the list of elements
   * @return the tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple tuple(List<java.lang.Object> elements) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.tuple(elements));
    return ret;
  }

  /**
   * Get an object value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.Object getValue(int pos) { 
    java.lang.Object ret = (Object) delegate.getValue(pos);
    return ret;
  }

  /**
   * Get a boolean value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Boolean getBoolean(int pos) { 
    Boolean ret = delegate.getBoolean(pos);
    return ret;
  }

  /**
   * Get a short value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Short getShort(int pos) { 
    Short ret = delegate.getShort(pos);
    return ret;
  }

  /**
   * Get an integer value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Integer getInteger(int pos) { 
    Integer ret = delegate.getInteger(pos);
    return ret;
  }

  /**
   * Get a long value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Long getLong(int pos) { 
    Long ret = delegate.getLong(pos);
    return ret;
  }

  /**
   * Get a float value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Float getFloat(int pos) { 
    Float ret = delegate.getFloat(pos);
    return ret;
  }

  /**
   * Get a double value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Double getDouble(int pos) { 
    Double ret = delegate.getDouble(pos);
    return ret;
  }

  /**
   * Get a string value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public String getString(int pos) { 
    String ret = delegate.getString(pos);
    return ret;
  }

  /**
   * Get a buffer value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public io.vertx.rxjava.core.buffer.Buffer getBuffer(int pos) { 
    io.vertx.rxjava.core.buffer.Buffer ret = io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(pos));
    return ret;
  }

  /**
   * Add an object value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addValue(java.lang.Object value) { 
    delegate.addValue(value);
    return this;
  }

  /**
   * Add a boolean value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addBoolean(Boolean value) { 
    delegate.addBoolean(value);
    return this;
  }

  /**
   * Add a short value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addShort(Short value) { 
    delegate.addShort(value);
    return this;
  }

  /**
   * Add an integer value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addInteger(Integer value) { 
    delegate.addInteger(value);
    return this;
  }

  /**
   * Add a long value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLong(Long value) { 
    delegate.addLong(value);
    return this;
  }

  /**
   * Add a float value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addFloat(Float value) { 
    delegate.addFloat(value);
    return this;
  }

  /**
   * Add a double value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addDouble(Double value) { 
    delegate.addDouble(value);
    return this;
  }

  /**
   * Add a string value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addString(String value) { 
    delegate.addString(value);
    return this;
  }

  /**
   * Add a buffer value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addBuffer(io.vertx.rxjava.core.buffer.Buffer value) { 
    delegate.addBuffer(value.getDelegate());
    return this;
  }

  public <T> T get(java.lang.Class<T> type, int pos) { 
    T ret = (T)TypeArg.of(type).wrap(delegate.get(io.vertx.lang.rxjava.Helper.unwrap(type), pos));
    return ret;
  }

  /**
   * @return the tuple size
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public void clear() { 
    delegate.clear();
  }

  /**
   * @return A String containing the {@link java.lang.Object} value of each element, separated by a comma (,) character
   */
  public String deepToString() { 
    String ret = delegate.deepToString();
    return ret;
  }

  /**
   * Wrap the provided <code>array</code> with a tuple.
   * <br/>
   * The array is not copied and is used as store for tuple elements.
   * @param array 
   * @return the list wrapped as a tuple
   */
  public static io.vertx.rxjava.sqlclient.Tuple wrap(java.lang.Object[] array) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)io.vertx.sqlclient.Tuple.wrap(array));
    return ret;
  }

  /**
   * Get a {@link java.time.temporal.Temporal} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.temporal.Temporal getTemporal(int pos) { 
    java.time.temporal.Temporal ret = delegate.getTemporal(pos);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDate} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.LocalDate getLocalDate(int pos) { 
    java.time.LocalDate ret = delegate.getLocalDate(pos);
    return ret;
  }

  /**
   * Get {@link java.time.LocalTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.LocalTime getLocalTime(int pos) { 
    java.time.LocalTime ret = delegate.getLocalTime(pos);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDateTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.LocalDateTime getLocalDateTime(int pos) { 
    java.time.LocalDateTime ret = delegate.getLocalDateTime(pos);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.OffsetTime getOffsetTime(int pos) { 
    java.time.OffsetTime ret = delegate.getOffsetTime(pos);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetDateTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.OffsetDateTime getOffsetDateTime(int pos) { 
    java.time.OffsetDateTime ret = delegate.getOffsetDateTime(pos);
    return ret;
  }

  /**
   * Get {@link java.util.UUID} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.util.UUID getUUID(int pos) { 
    java.util.UUID ret = delegate.getUUID(pos);
    return ret;
  }

  /**
   * Get  value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.math.BigDecimal getBigDecimal(int pos) { 
    java.math.BigDecimal ret = delegate.getBigDecimal(pos);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Boolean} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.Boolean[] getBooleanArray(int pos) { 
    java.lang.Boolean[] ret = delegate.getBooleanArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.Short} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.Short[] getShortArray(int pos) { 
    java.lang.Short[] ret = delegate.getShortArray(pos);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Integer} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.Integer[] getIntegerArray(int pos) { 
    java.lang.Integer[] ret = delegate.getIntegerArray(pos);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Long} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.Long[] getLongArray(int pos) { 
    java.lang.Long[] ret = delegate.getLongArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.Float} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.Float[] getFloatArray(int pos) { 
    java.lang.Float[] ret = delegate.getFloatArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.Double} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.Double[] getDoubleArray(int pos) { 
    java.lang.Double[] ret = delegate.getDoubleArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.String} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.lang.String[] getStringArray(int pos) { 
    java.lang.String[] ret = delegate.getStringArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.temporal.Temporal[] getTemporalArray(int pos) { 
    java.time.temporal.Temporal[] ret = delegate.getTemporalArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.LocalDate[] getLocalDateArray(int pos) { 
    java.time.LocalDate[] ret = delegate.getLocalDateArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.LocalTime[] getLocalTimeArray(int pos) { 
    java.time.LocalTime[] ret = delegate.getLocalTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.LocalDateTime[] getLocalDateTimeArray(int pos) { 
    java.time.LocalDateTime[] ret = delegate.getLocalDateTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.OffsetTime[] getOffsetTimeArray(int pos) { 
    java.time.OffsetTime[] ret = delegate.getOffsetTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public java.time.OffsetDateTime[] getOffsetDateTimeArray(int pos) { 
    java.time.OffsetDateTime[] ret = delegate.getOffsetDateTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param pos the column
   * @return the value or <code>null</code>
   */
  public java.util.UUID[] getUUIDArray(int pos) { 
    java.util.UUID[] ret = delegate.getUUIDArray(pos);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param pos the column
   * @return the value or <code>null</code>
   */
  public java.math.BigDecimal[] getBigDecimalArray(int pos) { 
    java.math.BigDecimal[] ret = delegate.getBigDecimalArray(pos);
    return ret;
  }

  /**
   * Add a {@link java.time.temporal.Temporal} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addTemporal(java.time.temporal.Temporal value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addTemporal(value));
    return ret;
  }

  /**
   * Add a {@link java.time.LocalDate} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLocalDate(java.time.LocalDate value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalDate(value));
    return ret;
  }

  /**
   * Add a {@link java.time.LocalTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLocalTime(java.time.LocalTime value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalTime(value));
    return ret;
  }

  /**
   * Add a {@link java.time.LocalDateTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLocalDateTime(java.time.LocalDateTime value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalDateTime(value));
    return ret;
  }

  /**
   * Add a {@link java.time.OffsetTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addOffsetTime(java.time.OffsetTime value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addOffsetTime(value));
    return ret;
  }

  /**
   * Add a {@link java.time.OffsetDateTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addOffsetDateTime(java.time.OffsetDateTime value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addOffsetDateTime(value));
    return ret;
  }

  /**
   * Add a {@link java.util.UUID} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addUUID(java.util.UUID value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addUUID(value));
    return ret;
  }

  /**
   * Add a  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addBigDecimal(java.math.BigDecimal value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addBigDecimal(value));
    return ret;
  }

  /**
   * Add an array of <code>Boolean</code> value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addBooleanArray(java.lang.Boolean[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addBooleanArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Short} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addShortArray(java.lang.Short[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addShortArray(value));
    return ret;
  }

  /**
   * Add an array of <code>Integer</code> value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addIntegerArray(java.lang.Integer[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addIntegerArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Long} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLongArray(java.lang.Long[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLongArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Float} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addFloatArray(java.lang.Float[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addFloatArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Double} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addDoubleArray(java.lang.Double[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addDoubleArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.String} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addStringArray(java.lang.String[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addStringArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addTemporalArray(java.time.temporal.Temporal[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addTemporalArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLocalDateArray(java.time.LocalDate[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalDateArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLocalTimeArray(java.time.LocalTime[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addLocalDateTimeArray(java.time.LocalDateTime[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addLocalDateTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addOffsetTimeArray(java.time.OffsetTime[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addOffsetTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addOffsetDateTimeArray(java.time.OffsetDateTime[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addOffsetDateTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addUUIDArray(java.util.UUID[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addUUIDArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Tuple addBigDecimalArray(java.math.BigDecimal[] value) { 
    io.vertx.rxjava.sqlclient.Tuple ret = io.vertx.rxjava.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.addBigDecimalArray(value));
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final java.lang.Object JSON_NULL = (Object) io.vertx.sqlclient.Tuple.JSON_NULL;
  public static Tuple newInstance(io.vertx.sqlclient.Tuple arg) {
    return arg != null ? new Tuple(arg) : null;
  }

}
