/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.Cookie;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse
implements WriteStream<io.vertx.rxjava.core.buffer.Buffer> {
    public static final TypeArg<HttpServerResponse> __TYPE_ARG = new TypeArg(obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse)obj), HttpServerResponse::getDelegate);
    private final io.vertx.core.http.HttpServerResponse delegate;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private MultiMap cached_0;
    private MultiMap cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerResponse that = (HttpServerResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public HttpServerResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
    }

    public io.vertx.core.http.HttpServerResponse getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Deprecated
    public Observable<Void> endObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerResponse write(io.vertx.rxjava.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public HttpServerResponse write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(io.vertx.rxjava.core.buffer.Buffer data) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(data, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpServerResponse putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public HttpServerResponse putTrailer(String name, String value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public HttpServerResponse write(String chunk, String enc) {
        this.delegate.write(chunk, enc);
        return this;
    }

    public HttpServerResponse write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, enc, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(String chunk, String enc) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(chunk, enc, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(String chunk, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse write(String chunk) {
        this.delegate.write(chunk);
        return this;
    }

    public HttpServerResponse write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(String chunk) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(chunk, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(String chunk) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse writeContinue() {
        this.delegate.writeContinue();
        return this;
    }

    @Override
    public void end(String chunk) {
        this.delegate.end(chunk);
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, handler);
    }

    @Deprecated
    public Observable<Void> endObservable(String chunk) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(chunk, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(String chunk) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void end(String chunk, String enc) {
        this.delegate.end(chunk, enc);
    }

    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, enc, handler);
    }

    @Deprecated
    public Observable<Void> endObservable(String chunk, String enc) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(chunk, enc, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(String chunk, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk) {
        this.delegate.end(chunk.getDelegate());
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> endObservable(io.vertx.rxjava.core.buffer.Buffer chunk) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(chunk, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer chunk) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    public HttpServerResponse sendFile(String filename) {
        this.delegate.sendFile(filename);
        return this;
    }

    public HttpServerResponse sendFile(String filename, long offset) {
        this.delegate.sendFile(filename, offset);
        return this;
    }

    public HttpServerResponse sendFile(String filename, long offset, long length) {
        this.delegate.sendFile(filename, offset, length);
        return this;
    }

    public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> sendFileObservable(String filename) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.sendFile(filename, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxSendFile(String filename) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> sendFileObservable(String filename, long offset) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.sendFile(filename, offset, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxSendFile(String filename, long offset) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> sendFileObservable(String filename, long offset, long length) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.sendFile(filename, offset, length, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxSendFile(String filename, long offset, long length) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean closed() {
        boolean ret = this.delegate.closed();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        this.delegate.headersEndHandler(handler);
        return this;
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public long bytesWritten() {
        long ret = this.delegate.bytesWritten();
        return ret;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpServerResponse push(HttpMethod method, String host, String path, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, host, path, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<HttpServerResponse> pushObservable(HttpMethod method, String host, String path) {
        ObservableFuture<HttpServerResponse> handler = RxHelper.observableFuture();
        this.push(method, host, path, handler.toHandler());
        return handler;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, host, path, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, path, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<HttpServerResponse> pushObservable(HttpMethod method, String path, MultiMap headers) {
        ObservableFuture<HttpServerResponse> handler = RxHelper.observableFuture();
        this.push(method, path, headers, handler.toHandler());
        return handler;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path, MultiMap headers) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, path, headers, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String path, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, path, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<HttpServerResponse> pushObservable(HttpMethod method, String path) {
        ObservableFuture<HttpServerResponse> handler = RxHelper.observableFuture();
        this.push(method, path, handler.toHandler());
        return handler;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, path, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, host, path, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<HttpServerResponse> pushObservable(HttpMethod method, String host, String path, MultiMap headers) {
        ObservableFuture<HttpServerResponse> handler = RxHelper.observableFuture();
        this.push(method, host, path, headers, handler.toHandler());
        return handler;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path, MultiMap headers) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, host, path, headers, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public void reset() {
        this.delegate.reset();
    }

    public void reset(long code) {
        this.delegate.reset(code);
    }

    public HttpServerResponse writeCustomFrame(int type, int flags, io.vertx.rxjava.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public HttpServerResponse writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public HttpServerResponse addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie.getDelegate());
        return this;
    }

    public Cookie removeCookie(String name) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name));
        return ret;
    }

    public Cookie removeCookie(String name, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, invalidate));
        return ret;
    }

    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        this.delegate.putTrailer(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

