/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.cli;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The parser transforms a CLI (a model) into an {@link io.vertx.reactivex.core.cli.CommandLine}. This {@link io.vertx.reactivex.core.cli.CommandLine}
 * has stored the argument and option values. Only  instance of parser should create
 * objects of this type.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.cli.CommandLine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.cli.CommandLine.class)
public class CommandLine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandLine that = (CommandLine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CommandLine> __TYPE_ARG = new TypeArg<>(    obj -> new CommandLine((io.vertx.core.cli.CommandLine) obj),
    CommandLine::getDelegate
  );

  private final io.vertx.core.cli.CommandLine delegate;
  
  public CommandLine(io.vertx.core.cli.CommandLine delegate) {
    this.delegate = delegate;
  }

  public CommandLine(Object delegate) {
    this.delegate = (io.vertx.core.cli.CommandLine)delegate;
  }

  public io.vertx.core.cli.CommandLine getDelegate() {
    return delegate;
  }


  /**
   * Creates a command line object from the {@link io.vertx.reactivex.core.cli.CLI}. This object is intended to be used by
   * the parser to set the argument and option values.
   * @param cli the CLI definition
   * @return the command line object
   */
  public static io.vertx.reactivex.core.cli.CommandLine create(io.vertx.reactivex.core.cli.CLI cli) { 
    io.vertx.reactivex.core.cli.CommandLine ret = io.vertx.reactivex.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)io.vertx.core.cli.CommandLine.create(cli.getDelegate()));
    return ret;
  }

  /**
   * @return the model of this command line object.
   */
  public io.vertx.reactivex.core.cli.CLI cli() { 
    io.vertx.reactivex.core.cli.CLI ret = io.vertx.reactivex.core.cli.CLI.newInstance((io.vertx.core.cli.CLI)delegate.cli());
    return ret;
  }

  /**
   * @return the ordered list of arguments. Arguments are command line arguments not matching an option.
   */
  public List<String> allArguments() { 
    List<String> ret = delegate.allArguments();
    return ret;
  }

  /**
   * Gets the value of an option with the matching name (can be the long name, short name or arg name).
   * @param name the name
   * @return the value, <code>null</code> if not set
   */
  public <T> T getOptionValue(String name) { 
    T ret = (T) delegate.getOptionValue(name);
    return ret;
  }

  /**
   * Gets the value of an argument with the matching name (arg name).
   * @param name the name
   * @return the value, <code>null</code> if not set
   */
  public <T> T getArgumentValue(String name) { 
    T ret = (T) delegate.getArgumentValue(name);
    return ret;
  }

  /**
   * Gets the value of an argument with the given index.
   * @param index the index
   * @return the value, <code>null</code> if not set
   */
  public <T> T getArgumentValue(int index) { 
    T ret = (T) delegate.getArgumentValue(index);
    return ret;
  }

  /**
   * Gets the value of an option marked as a flag.
   * <p/>
   * Calling this method an a non-flag option throws an {@link java.lang.IllegalStateException}.
   * @param name the option name
   * @return <code>true</code> if the flag has been set in the command line, <code>false</code> otherwise.
   */
  public boolean isFlagEnabled(String name) { 
    boolean ret = delegate.isFlagEnabled(name);
    return ret;
  }

  /**
   * Checks whether or not the given option has been assigned in the command line.
   * @param option the option
   * @return <code>true</code> if the option has received a value,  otherwise.
   */
  public boolean isOptionAssigned(io.vertx.core.cli.Option option) { 
    boolean ret = delegate.isOptionAssigned(option);
    return ret;
  }

  /**
   * Gets the raw values of the given option. Raw values are simple "String", not converted to the option type.
   * @param option the option
   * @return the list of values, empty if none
   */
  @Deprecated()
  public List<String> getRawValues(io.vertx.core.cli.Option option) { 
    List<String> ret = delegate.getRawValues(option);
    return ret;
  }

  /**
   * Gets the raw values of the given option. Raw values are simple "String", not converted to the option type.
   * @param option the option
   * @return the list of values, empty if none
   */
  public List<String> getRawValuesForOption(io.vertx.core.cli.Option option) { 
    List<String> ret = delegate.getRawValuesForOption(option);
    return ret;
  }

  /**
   * Gets the raw values of the given argument. Raw values are simple "String", not converted to the argument type.
   * @param argument the argument
   * @return the list of values, empty if none
   */
  public List<String> getRawValuesForArgument(io.vertx.core.cli.Argument argument) { 
    List<String> ret = delegate.getRawValuesForArgument(argument);
    return ret;
  }

  /**
   * Gets the raw value of the given option. Raw values are the values as given in the user command line.
   * @param option the option
   * @return the value, <code>null</code> if none.
   */
  public String getRawValueForOption(io.vertx.core.cli.Option option) { 
    String ret = delegate.getRawValueForOption(option);
    return ret;
  }

  /**
   * Checks whether or not the given option accept more values.
   * @param option the option
   * @return  if the option accepts more values,  otherwise.
   */
  public boolean acceptMoreValues(io.vertx.core.cli.Option option) { 
    boolean ret = delegate.acceptMoreValues(option);
    return ret;
  }

  /**
   * Gets the raw value of the given argument. Raw values are the values as given in the user command line.
   * @param arg the argument
   * @return the value, <code>null</code> if none.
   */
  public String getRawValueForArgument(io.vertx.core.cli.Argument arg) { 
    String ret = delegate.getRawValueForArgument(arg);
    return ret;
  }

  /**
   * Checks whether or not the given argument has been assigned in the command line.
   * @param arg the argument
   * @return <code>true</code> if the argument has received a value,  otherwise.
   */
  public boolean isArgumentAssigned(io.vertx.core.cli.Argument arg) { 
    boolean ret = delegate.isArgumentAssigned(arg);
    return ret;
  }

  /**
   * Checks whether or not the given option has been seen in the user command line.
   * @param option the option
   * @return <code>true</code> if the user command line has used the option
   */
  public boolean isSeenInCommandLine(io.vertx.core.cli.Option option) { 
    boolean ret = delegate.isSeenInCommandLine(option);
    return ret;
  }

  /**
   * Checks whether or not the command line is valid, i.e. all constraints from arguments and options have been
   * satisfied. This method is used when the parser validation is disabled.
   * @return <code>true</code> if the current {@link io.vertx.reactivex.core.cli.CommandLine} object is valid.  otherwise.
   */
  public boolean isValid() { 
    boolean ret = delegate.isValid();
    return ret;
  }

  /**
   * Checks whether or not the user has passed a "help" option and is asking for help.
   * @return <code>true</code> if the user command line has enabled a "Help" option,  otherwise.
   */
  public boolean isAskingForHelp() { 
    boolean ret = delegate.isAskingForHelp();
    return ret;
  }

  public static CommandLine newInstance(io.vertx.core.cli.CommandLine arg) {
    return arg != null ? new CommandLine(arg) : null;
  }

}
