/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.rbac;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Implementation of the Microprofile MP-JWT 1.1 RBAC based on the access token groups key.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC.class)
public class MicroProfileRBAC {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MicroProfileRBAC that = (MicroProfileRBAC) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MicroProfileRBAC> __TYPE_ARG = new TypeArg<>(    obj -> new MicroProfileRBAC((io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC) obj),
    MicroProfileRBAC::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC delegate;
  
  public MicroProfileRBAC(io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC delegate) {
    this.delegate = delegate;
  }

  public MicroProfileRBAC(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC)delegate;
  }

  public io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC getDelegate() {
    return delegate;
  }

  /**
   * Factory method to create a RBAC handler for tokens adhering to the MP-JWT 1.1 spec.
   * @return a RBAC validator
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2RBAC create() { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2RBAC ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2RBAC.newInstance((io.vertx.ext.auth.oauth2.OAuth2RBAC)io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC.create());
    return ret;
  }

  public static MicroProfileRBAC newInstance(io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC arg) {
    return arg != null ? new MicroProfileRBAC(arg) : null;
  }

}
