/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoService original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mongo.MongoService.class)
public class MongoService extends io.vertx.reactivex.ext.mongo.MongoClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoService that = (MongoService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoService> __TYPE_ARG = new TypeArg<>(    obj -> new MongoService((io.vertx.ext.mongo.MongoService) obj),
    MongoService::getDelegate
  );

  private final io.vertx.ext.mongo.MongoService delegate;
  
  public MongoService(io.vertx.ext.mongo.MongoService delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MongoService(Object delegate) {
    super((io.vertx.ext.mongo.MongoService)delegate);
    this.delegate = (io.vertx.ext.mongo.MongoService)delegate;
  }

  public io.vertx.ext.mongo.MongoService getDelegate() {
    return delegate;
  }

  /**
   * Create a proxy to a service that is deployed somewhere on the event bus
   * @param vertx the Vert.x instance
   * @param address the address the service is listening on on the event bus
   * @return the service
   */
  public static io.vertx.reactivex.ext.mongo.MongoService createEventBusProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.vertx.reactivex.ext.mongo.MongoService ret = io.vertx.reactivex.ext.mongo.MongoService.newInstance((io.vertx.ext.mongo.MongoService)io.vertx.ext.mongo.MongoService.createEventBusProxy(vertx.getDelegate(), address));
    return ret;
  }

  public io.vertx.reactivex.ext.mongo.MongoService save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.save(collection, document, resultHandler);
    return this;
  }

  public Maybe<String> rxSave(String collection, JsonObject document) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      save(collection, document, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService saveWithOptions(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.saveWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  public Maybe<String> rxSaveWithOptions(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      saveWithOptions(collection, document, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insert(collection, document, resultHandler);
    return this;
  }

  public Maybe<String> rxInsert(String collection, JsonObject document) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      insert(collection, document, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService insertWithOptions(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insertWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  public Maybe<String> rxInsertWithOptions(String collection, JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      insertWithOptions(collection, document, writeOption, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.update(collection, query, update, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxUpdate(String collection, JsonObject query, JsonObject update) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      update(collection, query, update, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      updateCollection(collection, query, update, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService updateWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxUpdateWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      updateWithOptions(collection, query, update, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.UpdateOptions options, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      updateCollectionWithOptions(collection, query, update, options, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replace(collection, query, replace, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxReplace(String collection, JsonObject query, JsonObject replace) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      replace(collection, query, replace, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocuments(collection, query, replace, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      replaceDocuments(collection, query, replace, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService replaceWithOptions(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replaceWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxReplaceWithOptions(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      replaceWithOptions(collection, query, replace, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.UpdateOptions options, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      replaceDocumentsWithOptions(collection, query, replace, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService bulkWrite(String collection, List<io.vertx.ext.mongo.BulkOperation> operations, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWrite(collection, operations, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWrite(String collection, List<io.vertx.ext.mongo.BulkOperation> operations) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      bulkWrite(collection, operations, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService bulkWriteWithOptions(String collection, List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      bulkWriteWithOptions(collection, operations, bulkWriteOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.find(collection, query, resultHandler);
    return this;
  }

  public Single<List<JsonObject>> rxFind(String collection, JsonObject query) { 
    return AsyncResultSingle.toSingle(handler -> {
      find(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.findWithOptions(collection, query, options, resultHandler);
    return this;
  }

  public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      findWithOptions(collection, query, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOne(collection, query, fields, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      findOne(collection, query, fields, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdate(collection, query, update, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      findOneAndUpdate(collection, query, update, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplace(collection, query, replace, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      findOneAndReplace(collection, query, replace, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDelete(collection, query, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      findOneAndDelete(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService findOneAndDeleteWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      findOneAndDeleteWithOptions(collection, query, findOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.count(collection, query, resultHandler);
    return this;
  }

  public Single<Long> rxCount(String collection, JsonObject query) { 
    return AsyncResultSingle.toSingle(handler -> {
      count(collection, query, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.remove(collection, query, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemove(String collection, JsonObject query) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      remove(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocuments(String collection, JsonObject query, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocuments(collection, query, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      removeDocuments(collection, query, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService removeWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemoveWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      removeWithOptions(collection, query, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocumentsWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      removeDocumentsWithOptions(collection, query, writeOption, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOne(collection, query, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemoveOne(String collection, JsonObject query) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      removeOne(collection, query, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocument(String collection, JsonObject query, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocument(collection, query, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      removeDocument(collection, query, handler);
    });
  }

  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoService removeOneWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOneWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  @Deprecated()
  public Completable rxRemoveOneWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      removeOneWithOptions(collection, query, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService removeDocumentWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, Handler<AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      removeDocumentWithOptions(collection, query, writeOption, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createCollection(collectionName, resultHandler);
    return this;
  }

  public Completable rxCreateCollection(String collectionName) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      createCollection(collectionName, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService getCollections(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getCollections(resultHandler);
    return this;
  }

  public Single<List<String>> rxGetCollections() { 
    return AsyncResultSingle.toSingle(handler -> {
      getCollections(handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropCollection(collection, resultHandler);
    return this;
  }

  public Completable rxDropCollection(String collection) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      dropCollection(collection, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndex(collection, key, resultHandler);
    return this;
  }

  public Completable rxCreateIndex(String collection, JsonObject key) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      createIndex(collection, key, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService createIndexWithOptions(String collection, JsonObject key, io.vertx.ext.mongo.IndexOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndexWithOptions(collection, key, options, resultHandler);
    return this;
  }

  public Completable rxCreateIndexWithOptions(String collection, JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      createIndexWithOptions(collection, key, options, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.listIndexes(collection, resultHandler);
    return this;
  }

  public Single<JsonArray> rxListIndexes(String collection) { 
    return AsyncResultSingle.toSingle(handler -> {
      listIndexes(collection, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropIndex(collection, indexName, resultHandler);
    return this;
  }

  public Completable rxDropIndex(String collection, String indexName) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      dropIndex(collection, indexName, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.runCommand(commandName, command, resultHandler);
    return this;
  }

  public Maybe<JsonObject> rxRunCommand(String commandName, JsonObject command) { 
    return AsyncResultMaybe.toMaybe(handler -> {
      runCommand(commandName, command, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, resultHandler);
    return this;
  }

  public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) { 
    return AsyncResultSingle.toSingle(handler -> {
      distinct(collection, fieldName, resultClassname, handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoService distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
    return this;
  }

  public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) { 
    return AsyncResultSingle.toSingle(handler -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, handler);
    });
  }

  public void close() { 
    delegate.close();
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mongo.MongoService.DEFAULT_POOL_NAME;
  /**
   * The name of the default database
   */
  public static final String DEFAULT_DB_NAME = io.vertx.ext.mongo.MongoService.DEFAULT_DB_NAME;
  public static MongoService newInstance(io.vertx.ext.mongo.MongoService arg) {
    return arg != null ? new MongoService(arg) : null;
  }

}
