/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an HTTP Cookie.
 * <p>
 * All cookies must have a name and a value and can optionally have other fields set such as path, domain, etc.
 * <p>
 * (Derived from io.netty.handler.codec.http.Cookie)
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.Cookie original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.Cookie.class)
public class Cookie extends io.vertx.reactivex.core.http.Cookie {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Cookie that = (Cookie) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Cookie> __TYPE_ARG = new TypeArg<>(    obj -> new Cookie((io.vertx.ext.web.Cookie) obj),
    Cookie::getDelegate
  );

  private final io.vertx.ext.web.Cookie delegate;
  
  public Cookie(io.vertx.ext.web.Cookie delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Cookie(Object delegate) {
    super((io.vertx.ext.web.Cookie)delegate);
    this.delegate = (io.vertx.ext.web.Cookie)delegate;
  }

  public io.vertx.ext.web.Cookie getDelegate() {
    return delegate;
  }

  /**
   * Create a new cookie
   * @param name the name of the cookie
   * @param value the cookie value
   * @return the cookie
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.Cookie cookie(String name, String value) { 
    io.vertx.reactivex.ext.web.Cookie ret = io.vertx.reactivex.ext.web.Cookie.newInstance((io.vertx.ext.web.Cookie)io.vertx.ext.web.Cookie.cookie(name, value));
    return ret;
  }

  @Deprecated()
  public io.vertx.reactivex.ext.web.Cookie setValue(String value) { 
    delegate.setValue(value);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.ext.web.Cookie setDomain(String domain) { 
    delegate.setDomain(domain);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.ext.web.Cookie setPath(String path) { 
    delegate.setPath(path);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.ext.web.Cookie setMaxAge(long maxAge) { 
    delegate.setMaxAge(maxAge);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.ext.web.Cookie setSecure(boolean secure) { 
    delegate.setSecure(secure);
    return this;
  }

  @Deprecated()
  public io.vertx.reactivex.ext.web.Cookie setHttpOnly(boolean httpOnly) { 
    delegate.setHttpOnly(httpOnly);
    return this;
  }

  /**
   * Has the cookie been changed? Changed cookieMap will be saved out in the response and sent to the browser.
   * @return true if changed
   */
  @Deprecated()
  public boolean isChanged() { 
    boolean ret = delegate.isChanged();
    return ret;
  }

  /**
   * Set the cookie as being changed. Changed will be true for a cookie just created, false by default if just
   * read from the request
   * @param changed true if changed
   */
  @Deprecated()
  public void setChanged(boolean changed) { 
    delegate.setChanged(changed);
  }

  /**
   * Has this Cookie been sent from the User Agent (the browser)? or was created during the executing on the request.
   * @return true if the cookie comes from the User Agent.
   */
  @Deprecated()
  public boolean isFromUserAgent() { 
    boolean ret = delegate.isFromUserAgent();
    return ret;
  }

  public static Cookie newInstance(io.vertx.ext.web.Cookie arg) {
    return arg != null ? new Cookie(arg) : null;
  }

}
