/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.contract.openapi3;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface for OpenAPI3RouterFactory. <br/>
 * To add an handler, use {@link io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory#addHandlerByOperationId}<br/>
 * Usage example:
 * <pre>
 * <code>OpenAPI3RouterFactory.create(vertx, "src/resources/spec.yaml", asyncResult -> {
  if (!asyncResult.succeeded()) {
     // IO failure or spec invalid</code> else {
 *     OpenAPI3RouterFactory routerFactory = asyncResult.result();
 *     routerFactory.addHandlerByOperationId("operation_id", routingContext -> {
 *        // Do something
 *     }, routingContext -> {
 *        // Do something with failure handler
 *     });
 *     Router router = routerFactory.getRouter();
 *  }
 * });
 * }
 * </pre>
 * <br/>
 * Handlers are loaded in this order:<br/>
 *  <ol>
 *   <li>Body handler (Customizable with </li>
 *   <li>Custom global handlers configurable with </li>
 *   <li>Global security handlers defined in upper spec level</li>
 *   <li>Operation specific security handlers</li>
 *   <li>Generated validation handler</li>
 *   <li>User handlers or "Not implemented" handler</li>
 * </ol>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory.class)
public class OpenAPI3RouterFactory implements io.vertx.reactivex.ext.web.api.contract.RouterFactory<io.swagger.v3.oas.models.OpenAPI> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenAPI3RouterFactory that = (OpenAPI3RouterFactory) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OpenAPI3RouterFactory> __TYPE_ARG = new TypeArg<>(    obj -> new OpenAPI3RouterFactory((io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory) obj),
    OpenAPI3RouterFactory::getDelegate
  );

  private final io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory delegate;
  
  public OpenAPI3RouterFactory(io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory delegate) {
    this.delegate = delegate;
  }

  public OpenAPI3RouterFactory(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory)delegate;
  }

  public io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.RoutingContext> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.RoutingContext>(o1 -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());

  /**
   * Mount to paths that have to follow a security schema a security handler
   * @param securitySchemaName 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory addSecurityHandler(String securitySchemaName, Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addSecurityHandler(securitySchemaName, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Set options of router factory. For more info 
   * @param options 
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * Get options of router factory. For more info 
   * @return 
   */
  public io.vertx.ext.web.api.contract.RouterFactoryOptions getOptions() { 
    io.vertx.ext.web.api.contract.RouterFactoryOptions ret = delegate.getOptions();
    return ret;
  }

  /**
   * Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   * without assigned handlers<br/>
   * <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
   * @return 
   */
  public io.vertx.reactivex.ext.web.Router getRouter() { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance((io.vertx.ext.web.Router)delegate.getRouter());
    return ret;
  }

  /**
   * @return 
   */
  @Deprecated()
  public Handler<io.vertx.reactivex.ext.web.RoutingContext> getValidationFailureHandler() { 
    Handler<io.vertx.reactivex.ext.web.RoutingContext> ret = new Handler<io.vertx.reactivex.ext.web.RoutingContext>() {
      public void handle(io.vertx.reactivex.ext.web.RoutingContext event) {
          delegate.getValidationFailureHandler().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Set default validation failure handler. You can enable/disable this feature from
   * 
   * @param validationFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setValidationFailureHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> validationFailureHandler) { 
    delegate.setValidationFailureHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        validationFailureHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Set not implemented failure handler. It's called when you don't define an handler for a
   * specific operation. You can enable/disable this feature from
   * 
   * @param notImplementedFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setNotImplementedFailureHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> notImplementedFailureHandler) { 
    delegate.setNotImplementedFailureHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        notImplementedFailureHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded files
   * @param bodyHandler 
   * @return self
   */
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setBodyHandler(io.vertx.reactivex.ext.web.handler.BodyHandler bodyHandler) { 
    delegate.setBodyHandler(bodyHandler.getDelegate());
    return this;
  }

  /**
   * Add global handler to be applied prior to {@link io.vertx.reactivex.ext.web.Router} being generated. <br/>
   * Please note that you should not add a body handler inside that list. If you want to modify the body handler, please use 
   * @param globalHandler 
   * @return this object
   */
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory addGlobalHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> globalHandler) { 
    delegate.addGlobalHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        globalHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * When set, this function is called while creating the payload of {@link io.vertx.ext.web.api.OperationRequest}
   * @param extraOperationContextPayloadMapper 
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setExtraOperationContextPayloadMapper(Function<io.vertx.reactivex.ext.web.RoutingContext, JsonObject> extraOperationContextPayloadMapper) { 
    delegate.setExtraOperationContextPayloadMapper(new Function<io.vertx.ext.web.RoutingContext,JsonObject>() {
      public JsonObject apply(io.vertx.ext.web.RoutingContext arg) {
        JsonObject ret = extraOperationContextPayloadMapper.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Add a particular scope validator. The main security schema will not be called if a specific scope validator is
   * configured
   * @param securitySchemaName 
   * @param scopeName 
   * @param handler 
   * @return this factory
   */
  public io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory addSecuritySchemaScopeValidator(String securitySchemaName, String scopeName, Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addSecuritySchemaScopeValidator(securitySchemaName, scopeName, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Add an handler by operation_id field in Operation object
   * @param operationId 
   * @param handler 
   * @return this factory
   */
  public io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory addHandlerByOperationId(String operationId, Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addHandlerByOperationId(operationId, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Add a failure handler by operation_id field in Operation object
   * @param operationId 
   * @param failureHandler 
   * @return this factory
   */
  public io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory addFailureHandlerByOperationId(String operationId, Handler<io.vertx.reactivex.ext.web.RoutingContext> failureHandler) { 
    delegate.addFailureHandlerByOperationId(operationId, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        failureHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Specify to route an incoming request for specified operation id to a Web Api Service mounted at the specified address on event bus. Please give a look at <a href="https://vertx.io/docs/vertx-web-api-service/java/">vertx-web-api-service documentation</a> for more informations
   * @param operationId 
   * @param address 
   * @return this factory
   */
  public io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory mountOperationToEventBus(String operationId, String address) { 
    delegate.mountOperationToEventBus(operationId, address);
    return this;
  }

  /**
   * Specify to route an incoming request for all operations that contains the specified tag to a Web Api Service mounted at the specified address on event bus.
   * The request is handled by the method that matches the operation id. Please give a look at <a href="https://vertx.io/docs/vertx-web-api-service/java/">vertx-web-api-service documentation</a> for more informations
   * @param tag 
   * @param address 
   * @return this factory
   */
  public io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory mountServiceFromTag(String tag, String address) { 
    delegate.mountServiceFromTag(tag, address);
    return this;
  }

  /**
   * Introspect the OpenAPI spec to mount handlers for all operations that specifies a x-vertx-event-bus annotation. Please give a look at <a href="https://vertx.io/docs/vertx-web-api-service/java/">vertx-web-api-service documentation</a> for more informations
   * @return this factory
   */
  public io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory mountServicesFromExtensions() { 
    delegate.mountServicesFromExtensions();
    return this;
  }

  /**
   * Create a new OpenAPI3RouterFactory
   * @param vertx 
   * @param url location of your spec. It can be an absolute path, a local path or remote url (with HTTP protocol)
   * @param handler When specification is loaded, this handler will be called with AsyncResult<OpenAPI3RouterFactory>
   */
  public static void create(io.vertx.reactivex.core.Vertx vertx, String url, Handler<AsyncResult<io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory>> handler) { 
    io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory.create(vertx.getDelegate(), url, new Handler<AsyncResult<io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory>>() {
      public void handle(AsyncResult<io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory.newInstance((io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Create a new OpenAPI3RouterFactory
   * @param vertx 
   * @param url location of your spec. It can be an absolute path, a local path or remote url (with HTTP protocol)
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory> rxCreate(io.vertx.reactivex.core.Vertx vertx, String url) { 
    return AsyncResultSingle.toSingle(handler -> {
      create(vertx, url, handler);
    });
  }

  /**
   * Create a new OpenAPI3RouterFactory
   * @param vertx 
   * @param url location of your spec. It can be an absolute path, a local path or remote url (with HTTP protocol)
   * @param auth list of authorization values needed to access the remote url. Each item should be json representation of an 
   * @param handler When specification is loaded, this handler will be called with AsyncResult<OpenAPI3RouterFactory>
   */
  public static void create(io.vertx.reactivex.core.Vertx vertx, String url, List<JsonObject> auth, Handler<AsyncResult<io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory>> handler) { 
    io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory.create(vertx.getDelegate(), url, auth, new Handler<AsyncResult<io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory>>() {
      public void handle(AsyncResult<io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory.newInstance((io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Create a new OpenAPI3RouterFactory
   * @param vertx 
   * @param url location of your spec. It can be an absolute path, a local path or remote url (with HTTP protocol)
   * @param auth list of authorization values needed to access the remote url. Each item should be json representation of an 
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory> rxCreate(io.vertx.reactivex.core.Vertx vertx, String url, List<JsonObject> auth) { 
    return AsyncResultSingle.toSingle(handler -> {
      create(vertx, url, auth, handler);
    });
  }

  public static OpenAPI3RouterFactory newInstance(io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory arg) {
    return arg != null ? new OpenAPI3RouterFactory(arg) : null;
  }

}
