/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Handler that will filter requests based on the request Host name.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.VirtualHostHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.VirtualHostHandler.class)
public class VirtualHostHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VirtualHostHandler that = (VirtualHostHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<VirtualHostHandler> __TYPE_ARG = new TypeArg<>(    obj -> new VirtualHostHandler((io.vertx.ext.web.handler.VirtualHostHandler) obj),
    VirtualHostHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.VirtualHostHandler delegate;
  
  public VirtualHostHandler(io.vertx.ext.web.handler.VirtualHostHandler delegate) {
    this.delegate = delegate;
  }

  public VirtualHostHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.VirtualHostHandler)delegate;
  }

  public io.vertx.ext.web.handler.VirtualHostHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler
   * @param hostname 
   * @param handler 
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.VirtualHostHandler create(String hostname, Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    io.vertx.reactivex.ext.web.handler.VirtualHostHandler ret = io.vertx.reactivex.ext.web.handler.VirtualHostHandler.newInstance((io.vertx.ext.web.handler.VirtualHostHandler)io.vertx.ext.web.handler.VirtualHostHandler.create(hostname, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    }));
    return ret;
  }

  public static VirtualHostHandler newInstance(io.vertx.ext.web.handler.VirtualHostHandler arg) {
    return arg != null ? new VirtualHostHandler(arg) : null;
  }

}
