/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.kafka.client.producer;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka producer.
 * <p>
 * The  provides global control over writing a record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.client.producer.KafkaProducer.class)
public class KafkaProducer<K,V> implements io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducer that = (KafkaProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaProducer> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaProducer((io.vertx.kafka.client.producer.KafkaProducer) obj),
    KafkaProducer::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducer<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public KafkaProducer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.producer.KafkaProducer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.producer.KafkaProducer getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V>> observer;
  private WriteStreamSubscriber<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V>> subscriber;

  public synchronized WriteStreamObserver<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V>> toObserver() {
    if (observer == null) {
      Function<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V>::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V>> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V>::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      end(handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxEnd(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      end(data, handler);
    });
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.reactivex.core.Vertx vertx, String name, java.util.Map<String, String> config) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.reactivex.core.Vertx vertx, String name, java.util.Map<String, String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config, io.vertx.lang.reactivex.Helper.unwrap(keyType), io.vertx.lang.reactivex.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> create(io.vertx.reactivex.core.Vertx vertx, java.util.Map<String, String> config) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> create(io.vertx.reactivex.core.Vertx vertx, java.util.Map<String, String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.reactivex.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config, io.vertx.lang.reactivex.Helper.unwrap(keyType), io.vertx.lang.reactivex.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> write(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> kafkaProducerRecord) { 
    delegate.write(kafkaProducerRecord.getDelegate());
    return this;
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> write(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Completable rxWrite(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> send(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    delegate.send(record.getDelegate());
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> send(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> record, Handler<AsyncResult<io.vertx.kafka.client.producer.RecordMetadata>> handler) { 
    delegate.send(record.getDelegate(), handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public Single<io.vertx.kafka.client.producer.RecordMetadata> rxSend(io.vertx.reactivex.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    return AsyncResultSingle.toSingle(handler -> {
      send(record, handler);
    });
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @param handler handler called on operation completed
   * @return current KafkaProducer instance
   */
  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> partitionsFor(String topic, Handler<AsyncResult<List<io.vertx.kafka.client.common.PartitionInfo>>> handler) { 
    delegate.partitionsFor(topic, handler);
    return this;
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaProducer instance
   */
  public Single<List<io.vertx.kafka.client.common.PartitionInfo>> rxPartitionsFor(String topic) { 
    return AsyncResultSingle.toSingle(handler -> {
      partitionsFor(topic, handler);
    });
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @param completionHandler handler called on operation completed
   * @return current KafkaProducer instance
   */
  public io.vertx.reactivex.kafka.client.producer.KafkaProducer<K, V> flush(Handler<Void> completionHandler) { 
    delegate.flush(completionHandler);
    return this;
  }

  /**
   * Close the producer
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the producer
   * @param completionHandler handler called on operation completed
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the producer
   * @return 
   */
  public Completable rxClose() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @param completionHandler handler called on operation completed
   */
  public void close(long timeout, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(timeout, completionHandler);
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @return 
   */
  public Completable rxClose(long timeout) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      close(timeout, handler);
    });
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg) {
    return arg != null ? new KafkaProducer<K,V>(arg) : null;
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
