/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This factory is deprecated use {@link io.vertx.reactivex.redis.client.Redis} instead,
 * or for a typed API {@link io.vertx.reactivex.redis.client.RedisAPI}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.Script original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.Script.class)
public class Script {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Script that = (Script) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Script> __TYPE_ARG = new TypeArg<>(    obj -> new Script((io.vertx.redis.Script) obj),
    Script::getDelegate
  );

  private final io.vertx.redis.Script delegate;
  
  public Script(io.vertx.redis.Script delegate) {
    this.delegate = delegate;
  }

  public Script(Object delegate) {
    this.delegate = (io.vertx.redis.Script)delegate;
  }

  public io.vertx.redis.Script getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.redis.Script create(String script) { 
    io.vertx.reactivex.redis.Script ret = io.vertx.reactivex.redis.Script.newInstance((io.vertx.redis.Script)io.vertx.redis.Script.create(script));
    return ret;
  }

  public static io.vertx.reactivex.redis.Script create(String script, String sha1) { 
    io.vertx.reactivex.redis.Script ret = io.vertx.reactivex.redis.Script.newInstance((io.vertx.redis.Script)io.vertx.redis.Script.create(script, sha1));
    return ret;
  }

  public String getScript() { 
    String ret = delegate.getScript();
    return ret;
  }

  public String getSha1() { 
    String ret = delegate.getSha1();
    return ret;
  }

  public static Script newInstance(io.vertx.redis.Script arg) {
    return arg != null ? new Script(arg) : null;
  }

}
