/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A set of rows.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.RowSet original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.RowSet.class)
public class RowSet<R> extends io.vertx.reactivex.sqlclient.SqlResult<io.vertx.reactivex.sqlclient.RowSet<R>> implements Iterable<R> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RowSet that = (RowSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RowSet> __TYPE_ARG = new TypeArg<>(    obj -> new RowSet((io.vertx.sqlclient.RowSet) obj),
    RowSet::getDelegate
  );

  private final io.vertx.sqlclient.RowSet<R> delegate;
  public final TypeArg<R> __typeArg_0;
  
  public RowSet(io.vertx.sqlclient.RowSet delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public RowSet(Object delegate, TypeArg<R> typeArg_0) {
    super((io.vertx.sqlclient.RowSet)delegate);
    this.delegate = (io.vertx.sqlclient.RowSet)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.RowSet getDelegate() {
    return delegate;
  }


  /**
   * Get the result value.
   * @return the result
   */
  public io.vertx.reactivex.sqlclient.RowSet<R> value() { 
    io.vertx.reactivex.sqlclient.RowSet<R> ret = io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)delegate.value(), __typeArg_0);
    return ret;
  }

  public io.vertx.reactivex.sqlclient.RowIterator<R> iterator() { 
    io.vertx.reactivex.sqlclient.RowIterator<R> ret = io.vertx.reactivex.sqlclient.RowIterator.newInstance((io.vertx.sqlclient.RowIterator)delegate.iterator(), __typeArg_0);
    return ret;
  }

  public io.vertx.reactivex.sqlclient.RowSet<R> next() { 
    io.vertx.reactivex.sqlclient.RowSet<R> ret = io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)delegate.next(), __typeArg_0);
    return ret;
  }

  public static <R> RowSet<R> newInstance(io.vertx.sqlclient.RowSet arg) {
    return arg != null ? new RowSet<R>(arg) : null;
  }

  public static <R> RowSet<R> newInstance(io.vertx.sqlclient.RowSet arg, TypeArg<R> __typeArg_R) {
    return arg != null ? new RowSet<R>(arg, __typeArg_R) : null;
  }

}
