/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.collect.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.unit.collect.EventBusCollector;
import io.vertx.ext.unit.impl.FailureImpl;
import io.vertx.ext.unit.impl.TestResultImpl;
import io.vertx.ext.unit.report.TestCaseReport;
import io.vertx.ext.unit.report.TestResult;
import io.vertx.ext.unit.report.TestSuiteReport;

public class EventBusCollectorImpl
implements EventBusCollector,
Handler<Message<JsonObject>> {
    private final Vertx vertx;
    private final Handler<TestSuiteReport> reporter;
    private Handler<TestCaseReport> testCaseRunnerHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private TestSuiteReport runner;
    private Handler<TestResult> testCaseHandler;

    public EventBusCollectorImpl(Vertx vertx, Handler<TestSuiteReport> reporter) {
        this.reporter = reporter;
        this.vertx = vertx;
    }

    public void handle(Message<JsonObject> event) {
        JsonObject body = (JsonObject)event.body();
        String type = body.getString("type", "");
        final String name = body.getString("name");
        switch (type) {
            case "testSuiteBegin": {
                this.runner = new TestSuiteReport(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public TestSuiteReport exceptionHandler(Handler<Throwable> handler) {
                        EventBusCollectorImpl.this.exceptionHandler = handler;
                        return this;
                    }

                    @Override
                    public TestSuiteReport handler(Handler<TestCaseReport> handler) {
                        EventBusCollectorImpl.this.testCaseRunnerHandler = handler;
                        return this;
                    }

                    public ReadStream<TestCaseReport> fetch(long amount) {
                        return this;
                    }

                    @Override
                    public TestSuiteReport pause() {
                        return this;
                    }

                    @Override
                    public TestSuiteReport resume() {
                        return this;
                    }

                    @Override
                    public TestSuiteReport endHandler(Handler<Void> handler) {
                        EventBusCollectorImpl.this.endHandler = handler;
                        return this;
                    }
                };
                this.reporter.handle((Object)this.runner);
                break;
            }
            case "testCaseBegin": {
                if (this.testCaseRunnerHandler == null) break;
                this.testCaseRunnerHandler.handle((Object)new TestCaseReport(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public TestCaseReport endHandler(Handler<TestResult> handler) {
                        EventBusCollectorImpl.this.testCaseHandler = handler;
                        return this;
                    }
                });
                break;
            }
            case "testSuiteError": {
                JsonObject failureJson = body.getJsonObject("failure");
                if (failureJson == null || this.exceptionHandler == null) break;
                FailureImpl failure = new FailureImpl(failureJson);
                Throwable cause = failure.cause();
                if (cause == null) {
                    cause = new Exception(failureJson.getString("message"));
                }
                this.exceptionHandler.handle((Object)cause);
                break;
            }
            case "testCaseEnd": {
                if (this.testCaseHandler == null) break;
                JsonObject failureJson = body.getJsonObject("failure");
                FailureImpl failure = null;
                if (failureJson != null) {
                    failure = new FailureImpl(failureJson);
                }
                TestResultImpl result = new TestResultImpl(name, (long)body.getLong("beginTime", Long.valueOf(0L)), (long)body.getLong("durationTime", Long.valueOf(0L)), failure);
                this.testCaseHandler.handle((Object)result);
                this.testCaseHandler = null;
                break;
            }
            case "testSuiteEnd": {
                if (this.endHandler == null) break;
                this.endHandler.handle(null);
            }
        }
    }

    public MessageConsumer<JsonObject> register(String address) {
        return this.vertx.eventBus().consumer(address, (Handler)this);
    }

    @Override
    public Handler<Message<JsonObject>> asMessageHandler() {
        return this;
    }
}

