/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.openapi.RouteNamingStrategy;
import io.vertx.ext.web.openapi.RouterBuilderOptionsConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class RouterBuilderOptions {
    public static final boolean DEFAULT_MOUNT_NOT_IMPLEMENTED_HANDLER = true;
    public static final boolean DEFAULT_REQUIRE_SECURITY_HANDLERS = true;
    public static final boolean DEFAULT_MOUNT_RESPONSE_CONTENT_TYPE_HANDLER = true;
    public static final String DEFAULT_OPERATION_MODEL_KEY = null;
    public static final RouteNamingStrategy DEFAULT_ROUTE_NAMING_STRATEGY = RouteNamingStrategy.OPERATION_OPENAPI_PATH;
    public static final String DEFAULT_CONTRACT_ENDPOINT = null;
    public static final String STANDARD_CONTRACT_ENDPOINT = "/openapi";
    private boolean mountNotImplementedHandler;
    private boolean requireSecurityHandlers;
    private boolean mountResponseContentTypeHandler;
    private String operationModelKey;
    private RouteNamingStrategy routeNamingStrategy;
    private String contractEndpoint;

    public RouterBuilderOptions() {
        this.init();
    }

    public RouterBuilderOptions(JsonObject json) {
        this.init();
        RouterBuilderOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RouterBuilderOptions(RouterBuilderOptions other) {
        this.mountNotImplementedHandler = other.isMountNotImplementedHandler();
        this.requireSecurityHandlers = other.isRequireSecurityHandlers();
        this.mountResponseContentTypeHandler = other.isMountResponseContentTypeHandler();
        this.operationModelKey = other.getOperationModelKey();
        this.routeNamingStrategy = other.getRouteNamingStrategy();
        this.contractEndpoint = other.getContractEndpoint();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RouterBuilderOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.mountNotImplementedHandler = true;
        this.requireSecurityHandlers = true;
        this.mountResponseContentTypeHandler = true;
        this.operationModelKey = DEFAULT_OPERATION_MODEL_KEY;
        this.routeNamingStrategy = DEFAULT_ROUTE_NAMING_STRATEGY;
        this.contractEndpoint = DEFAULT_CONTRACT_ENDPOINT;
    }

    public boolean isMountNotImplementedHandler() {
        return this.mountNotImplementedHandler;
    }

    @Fluent
    public RouterBuilderOptions setMountNotImplementedHandler(boolean mountOperationsWithoutHandler) {
        this.mountNotImplementedHandler = mountOperationsWithoutHandler;
        return this;
    }

    public boolean isRequireSecurityHandlers() {
        return this.requireSecurityHandlers;
    }

    @Fluent
    public RouterBuilderOptions setRequireSecurityHandlers(boolean requireSecurityHandlers) {
        this.requireSecurityHandlers = requireSecurityHandlers;
        return this;
    }

    public boolean isMountResponseContentTypeHandler() {
        return this.mountResponseContentTypeHandler;
    }

    @Fluent
    public RouterBuilderOptions setMountResponseContentTypeHandler(boolean mountResponseContentTypeHandler) {
        this.mountResponseContentTypeHandler = mountResponseContentTypeHandler;
        return this;
    }

    public String getOperationModelKey() {
        return this.operationModelKey;
    }

    @Fluent
    public RouterBuilderOptions setOperationModelKey(String operationModelKey) {
        this.operationModelKey = operationModelKey;
        return this;
    }

    public RouteNamingStrategy getRouteNamingStrategy() {
        return this.routeNamingStrategy;
    }

    @Fluent
    public RouterBuilderOptions setRouteNamingStrategy(RouteNamingStrategy routeNamingStrategy) {
        this.routeNamingStrategy = routeNamingStrategy;
        return this;
    }

    public String getContractEndpoint() {
        return this.contractEndpoint;
    }

    @Fluent
    public RouterBuilderOptions setContractEndpoint(String contractEndpoint) {
        this.contractEndpoint = contractEndpoint;
        return this;
    }
}

