/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.openapi.impl.GeneratorContext;
import io.vertx.ext.web.openapi.impl.ParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.SchemaHolder;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.parameter.ParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessorImpl;
import io.vertx.ext.web.validation.impl.parameter.SingleValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;

public class JsonParameterProcessorGenerator
implements ParameterProcessorGenerator {
    private static final JsonPointer CONTENT_JSON_POINTER = JsonPointer.create().append("content").append("application/json");
    private static final JsonPointer SCHEMA_POINTER = CONTENT_JSON_POINTER.copy().append("schema");

    @Override
    public boolean canGenerate(JsonObject parameter, JsonObject fakeSchema, ParameterLocation parsedLocation, String parsedStyle) {
        return CONTENT_JSON_POINTER.queryJson((Object)parameter) != null;
    }

    @Override
    public ParameterProcessor generate(JsonObject parameter, JsonObject fakeSchema, JsonPointer parameterPointer, ParameterLocation parsedLocation, String parsedStyle, GeneratorContext context) {
        JsonObject originalSchema = (JsonObject)SCHEMA_POINTER.queryJsonOrDefault((Object)parameter, (Object)new JsonObject());
        SchemaHolder schemas = context.getSchemaHolder(originalSchema, context.fakeSchema(fakeSchema), parameterPointer.copy().append("content").append("application/json").append("schema"));
        return new ParameterProcessorImpl(parameter.getString("name"), parsedLocation, parameter.getBoolean("required", Boolean.valueOf(false)) == false, (ParameterParser)new SingleValueParameterParser(parsedLocation.lowerCaseIfNeeded(parameter.getString("name")), ValueParser.JSON_PARSER), (ValueValidator)schemas.getValidator());
    }
}

