/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.experimental;

import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBase;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoSearchGet;
import io.weaviate.client.v1.experimental.Metadata;
import io.weaviate.client.v1.experimental.Where;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class SearchOptions<SELF extends SearchOptions<SELF>> {
    private Integer limit;
    private Integer offset;
    private Integer autocut;
    private String after;
    private String consistencyLevel;
    private Where where;
    private List<String> returnProperties = new ArrayList<String>();
    private List<Metadata> returnMetadata = new ArrayList<Metadata>();

    void append(WeaviateProtoSearchGet.SearchRequest.Builder search) {
        if (this.limit != null) {
            search.setLimit(this.limit);
        }
        if (this.offset != null) {
            search.setOffset(this.offset);
        }
        if (StringUtils.isNotBlank((CharSequence)this.after)) {
            search.setAfter(this.after);
        }
        if (StringUtils.isNotBlank((CharSequence)this.consistencyLevel)) {
            search.setConsistencyLevelValue(Integer.valueOf(this.consistencyLevel));
        }
        if (this.autocut != null) {
            search.setAutocut(this.autocut);
        }
        if (this.where != null && !this.where.isEmpty()) {
            WeaviateProtoBase.Filters.Builder filters = WeaviateProtoBase.Filters.newBuilder();
            this.where.append(filters);
            search.setFilters(filters);
        }
        if (!this.returnMetadata.isEmpty()) {
            WeaviateProtoSearchGet.MetadataRequest.Builder metadata = WeaviateProtoSearchGet.MetadataRequest.newBuilder();
            this.returnMetadata.forEach(m -> m.append(metadata));
            search.setMetadata(metadata);
        }
        if (!this.returnProperties.isEmpty()) {
            WeaviateProtoSearchGet.PropertiesRequest.Builder properties = WeaviateProtoSearchGet.PropertiesRequest.newBuilder();
            for (String property : this.returnProperties) {
                properties.addNonRefProperties(property);
            }
            search.setProperties(properties);
        }
    }

    public final SELF limit(Integer limit) {
        this.limit = limit;
        return (SELF)this;
    }

    public final SELF offset(Integer offset) {
        this.offset = offset;
        return (SELF)this;
    }

    public final SELF autocut(Integer autocut) {
        this.autocut = autocut;
        return (SELF)this;
    }

    public final SELF after(String after) {
        this.after = after;
        return (SELF)this;
    }

    public final SELF consistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return (SELF)this;
    }

    public final SELF where(Where where) {
        this.where = where;
        return (SELF)this;
    }

    @SafeVarargs
    public final SELF returnProperties(String ... properties) {
        this.returnProperties = Arrays.asList(properties);
        return (SELF)this;
    }

    @SafeVarargs
    public final SELF returnMetadata(Metadata ... metadata) {
        this.returnMetadata = Arrays.asList(metadata);
        return (SELF)this;
    }
}

