/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo;

import brave.Span;
import brave.internal.Nullable;
import brave.internal.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

final class DubboParser {
    static final Map<Integer, String> ERROR_CODE_NUMBER_TO_NAME = DubboParser.errorCodeNumberToName();

    DubboParser() {
    }

    static Map<Integer, String> errorCodeNumberToName() {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (Field field : RpcException.class.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
            try {
                result.put((Integer)field.get(null), field.getName());
            }
            catch (Exception e) {
                assert (false) : e.getMessage();
                Platform.get().log("Error reading error code %s", (Object)field, (Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    static String method(Invocation invocation) {
        String methodName = invocation.getMethodName();
        if ("$invoke".equals(methodName) || "$invokeAsync".equals(methodName)) {
            Object[] arguments = invocation.getArguments();
            methodName = arguments != null && arguments.length > 0 && arguments[0] instanceof String ? (String)arguments[0] : null;
        }
        return methodName != null && !methodName.isEmpty() ? methodName : null;
    }

    @Nullable
    static String service(Invoker<?> invoker) {
        URL url = invoker.getUrl();
        if (url == null) {
            return null;
        }
        String service = url.getServiceInterface();
        return service != null && !service.isEmpty() ? service : null;
    }

    static boolean parseRemoteIpAndPort(Span span) {
        RpcContext rpcContext = RpcContext.getContext();
        InetSocketAddress remoteAddress = rpcContext.getRemoteAddress();
        if (remoteAddress == null) {
            return false;
        }
        return span.remoteIpAndPort(Platform.get().getHostString(remoteAddress), remoteAddress.getPort());
    }

    @Nullable
    static String errorCode(Throwable error) {
        if (error instanceof RpcException) {
            return ERROR_CODE_NUMBER_TO_NAME.get(((RpcException)error).getCode());
        }
        return null;
    }
}

