/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.grpc.GrpcParser;
import brave.grpc.GrpcRequest;
import brave.rpc.RpcClientRequest;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Map;

public final class GrpcClientRequest
extends RpcClientRequest
implements GrpcRequest {
    final Map<String, Metadata.Key<String>> nameToKey;
    final MethodDescriptor<?, ?> methodDescriptor;
    final CallOptions callOptions;
    final ClientCall<?, ?> call;
    final Metadata headers;

    GrpcClientRequest(Map<String, Metadata.Key<String>> nameToKey, MethodDescriptor<?, ?> methodDescriptor, CallOptions callOptions, ClientCall<?, ?> call, Metadata headers) {
        if (nameToKey == null) {
            throw new NullPointerException("nameToKey == null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor == null");
        }
        if (callOptions == null) {
            throw new NullPointerException("callOptions == null");
        }
        if (call == null) {
            throw new NullPointerException("call == null");
        }
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        this.nameToKey = nameToKey;
        this.methodDescriptor = methodDescriptor;
        this.callOptions = callOptions;
        this.call = call;
        this.headers = headers;
    }

    public Object unwrap() {
        return this.call;
    }

    public String method() {
        return GrpcParser.method(this.methodDescriptor.getFullMethodName());
    }

    public String service() {
        return GrpcParser.service(this.methodDescriptor.getFullMethodName());
    }

    @Override
    public MethodDescriptor<?, ?> methodDescriptor() {
        return this.methodDescriptor;
    }

    public CallOptions callOptions() {
        return this.callOptions;
    }

    public ClientCall<?, ?> call() {
        return this.call;
    }

    @Override
    public Metadata headers() {
        return this.headers;
    }

    protected void propagationField(String keyName, String value) {
        if (keyName == null) {
            throw new NullPointerException("keyName == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        Metadata.Key<String> key = this.nameToKey.get(keyName);
        if (key == null) {
            assert (false) : "We currently don't support setting headers except propagation fields";
            return;
        }
        this.headers.removeAll(key);
        this.headers.put(key, (Object)value);
    }
}

