/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.kafka.clients.KafkaConsumerRequest;
import brave.kafka.clients.KafkaHeaders;
import brave.kafka.clients.KafkaProducerRequest;
import brave.kafka.clients.TracingConsumer;
import brave.kafka.clients.TracingProducer;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public final class KafkaTracing {
    static final Propagation.Getter<Headers, String> GETTER = new Propagation.Getter<Headers, String>(){

        public String get(Headers request, String key) {
            return KafkaHeaders.lastStringHeader(request, key);
        }

        public String toString() {
            return "Headers::lastHeader";
        }
    };
    final MessagingTracing messagingTracing;
    final Tracer tracer;
    final TraceContext.Extractor<KafkaProducerRequest> producerExtractor;
    final TraceContext.Extractor<KafkaConsumerRequest> consumerExtractor;
    final TraceContext.Extractor<Headers> processorExtractor;
    final TraceContext.Injector<KafkaProducerRequest> producerInjector;
    final TraceContext.Injector<KafkaConsumerRequest> consumerInjector;
    final Set<String> traceIdHeaders;
    final TraceContextOrSamplingFlags emptyExtraction;
    final SamplerFunction<MessagingRequest> producerSampler;
    final SamplerFunction<MessagingRequest> consumerSampler;
    final String remoteServiceName;
    final boolean singleRootSpanOnReceiveBatch;

    public static KafkaTracing create(Tracing tracing) {
        return KafkaTracing.newBuilder(tracing).build();
    }

    public static KafkaTracing create(MessagingTracing messagingTracing) {
        return KafkaTracing.newBuilder(messagingTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return KafkaTracing.newBuilder(MessagingTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(messagingTracing);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    KafkaTracing(Builder builder) {
        this.messagingTracing = builder.messagingTracing;
        this.tracer = builder.messagingTracing.tracing().tracer();
        Propagation propagation = this.messagingTracing.propagation();
        this.producerExtractor = propagation.extractor(KafkaProducerRequest.GETTER);
        this.consumerExtractor = propagation.extractor(KafkaConsumerRequest.GETTER);
        this.processorExtractor = propagation.extractor(GETTER);
        this.producerInjector = propagation.injector(KafkaProducerRequest.SETTER);
        this.consumerInjector = propagation.injector(KafkaConsumerRequest.SETTER);
        this.producerSampler = this.messagingTracing.producerSampler();
        this.consumerSampler = this.messagingTracing.consumerSampler();
        this.remoteServiceName = builder.remoteServiceName;
        this.singleRootSpanOnReceiveBatch = builder.singleRootSpanOnReceiveBatch;
        this.traceIdHeaders = new LinkedHashSet<String>(propagation.keys());
        this.emptyExtraction = propagation.extractor((c, k) -> null).extract((Object)Boolean.TRUE);
    }

    public MessagingTracing messagingTracing() {
        return this.messagingTracing;
    }

    public <K, V> Consumer<K, V> consumer(Consumer<K, V> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer == null");
        }
        return new TracingConsumer<K, V>(consumer, this);
    }

    public <K, V> Producer<K, V> producer(Producer<K, V> producer) {
        if (producer == null) {
            throw new NullPointerException("producer == null");
        }
        return new TracingProducer<K, V>(producer, this);
    }

    public Span nextSpan(ConsumerRecord<?, ?> record) {
        TraceContextOrSamplingFlags extracted = this.extractAndClearTraceIdHeaders(this.processorExtractor, record.headers(), record.headers());
        Span result = this.tracer.nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            KafkaTracing.addTags(record, (SpanCustomizer)result);
        }
        return result;
    }

    <R> TraceContextOrSamplingFlags extractAndClearTraceIdHeaders(TraceContext.Extractor<R> extractor, R request, Headers headers) {
        TraceContextOrSamplingFlags extracted = extractor.extract(request);
        if (extracted.samplingFlags() == null) {
            this.clearTraceIdHeaders(headers);
        }
        return extracted;
    }

    Span nextMessagingSpan(SamplerFunction<MessagingRequest> sampler, MessagingRequest request, TraceContextOrSamplingFlags extracted) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return this.tracer.nextSpan(extracted);
    }

    void clearTraceIdHeaders(Headers headers) {
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            Header next = (Header)i.next();
            if (!this.traceIdHeaders.contains(next.key())) continue;
            i.remove();
        }
    }

    static void addTags(ConsumerRecord<?, ?> record, SpanCustomizer result) {
        if (record.key() instanceof String && !"".equals(record.key())) {
            result.tag("kafka.key", record.key().toString());
        }
        result.tag("kafka.topic", record.topic());
    }

    static void log(Throwable thrown, String msg, Object zero, @Nullable Object one) {
        Object[] objectArray;
        Logger logger = LoggerHolder.LOG;
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINE, msg);
        lr.setLoggerName(LoggerHolder.LOGGER_NAME);
        if (one != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = zero;
            objectArray = objectArray2;
            objectArray2[1] = one;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = zero;
        }
        Object[] params = objectArray;
        lr.setParameters(params);
        lr.setThrown(thrown);
        logger.log(lr);
    }

    public static final class Builder {
        final MessagingTracing messagingTracing;
        String remoteServiceName = "kafka";
        boolean singleRootSpanOnReceiveBatch = true;

        Builder(MessagingTracing messagingTracing) {
            if (messagingTracing == null) {
                throw new NullPointerException("messagingTracing == null");
            }
            this.messagingTracing = messagingTracing;
        }

        Builder(KafkaTracing kafkaTracing) {
            this.messagingTracing = kafkaTracing.messagingTracing;
            this.remoteServiceName = kafkaTracing.remoteServiceName;
            this.singleRootSpanOnReceiveBatch = kafkaTracing.singleRootSpanOnReceiveBatch;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public Builder singleRootSpanOnReceiveBatch(boolean singleRootSpanOnReceiveBatch) {
            this.singleRootSpanOnReceiveBatch = singleRootSpanOnReceiveBatch;
            return this;
        }

        public KafkaTracing build() {
            return new KafkaTracing(this);
        }
    }

    private static final class LoggerHolder {
        static final String LOGGER_NAME = KafkaTracing.class.getName();
        static final Logger LOG = Logger.getLogger(LOGGER_NAME);

        private LoggerHolder() {
        }
    }
}

