/*
 * Decompiled with CFR 0.152.
 */
package brave.mysql;

import brave.Span;
import brave.propagation.ThreadLocalSpan;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetInternalMethods;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StatementInterceptorV2;
import java.net.URI;
import java.sql.SQLException;
import java.util.Properties;

public class TracingStatementInterceptor
implements StatementInterceptorV2 {
    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, Connection connection) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.next();
        if (span == null || span.isNoop()) {
            return null;
        }
        if (interceptedStatement instanceof PreparedStatement) {
            sql = ((PreparedStatement)interceptedStatement).getPreparedSql();
        }
        int spaceIndex = sql.indexOf(32);
        span.kind(Span.Kind.CLIENT).name(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        span.tag("sql.query", sql);
        TracingStatementInterceptor.parseServerIpAndPort(connection, span);
        span.start();
        return null;
    }

    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, Connection connection, int warningCount, boolean noIndexUsed, boolean noGoodIndexUsed, SQLException statementException) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return null;
        }
        if (statementException != null) {
            span.error((Throwable)statementException);
            span.tag("error", Integer.toString(statementException.getErrorCode()));
        }
        span.finish();
        return null;
    }

    static void parseServerIpAndPort(Connection connection, Span span) {
        try {
            URI url = URI.create(connection.getMetaData().getURL().substring(5));
            String remoteServiceName = connection.getProperties().getProperty("zipkinServiceName");
            if (remoteServiceName == null || "".equals(remoteServiceName)) {
                String databaseName = connection.getCatalog();
                remoteServiceName = databaseName != null && !databaseName.isEmpty() ? "mysql-" + databaseName : "mysql";
            }
            span.remoteServiceName(remoteServiceName);
            String host = connection.getHost();
            if (host != null) {
                span.remoteIpAndPort(host, url.getPort() == -1 ? 3306 : url.getPort());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public void init(Connection conn, Properties props) {
    }

    public void destroy() {
    }
}

