/*
 * Decompiled with CFR 0.152.
 */
package brave.netty.http;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.Throwables;
import brave.netty.http.NettyHttpTracing;
import brave.propagation.CurrentTraceContext;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.Attribute;
import java.net.InetSocketAddress;
import java.net.URI;

final class TracingHttpServerHandler
extends ChannelDuplexHandler {
    final CurrentTraceContext currentTraceContext;
    final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;

    TracingHttpServerHandler(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof HttpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        HttpRequestWrapper request = new HttpRequestWrapper((HttpRequest)msg, (InetSocketAddress)ctx.channel().remoteAddress());
        ctx.channel().attr(NettyHttpTracing.REQUEST_ATTRIBUTE).set((Object)request);
        Span span = this.handler.handleReceive((HttpServerRequest)request);
        ctx.channel().attr(NettyHttpTracing.SPAN_ATTRIBUTE).set((Object)span);
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(span.context());
        Throwable error = null;
        try {
            ctx.fireChannelRead(msg);
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Error e) {
            Throwables.propagateIfFatal((Throwable)e);
            error = e;
            throw e;
        }
        finally {
            if (error != null) {
                span.error(error).finish();
            }
            scope.close();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise prm) {
        Attribute spanAttr = ctx.channel().attr(NettyHttpTracing.SPAN_ATTRIBUTE);
        Span span = (Span)spanAttr.get();
        spanAttr.compareAndSet((Object)span, null);
        if (span == null || !(msg instanceof HttpResponse)) {
            ctx.write(msg, prm);
            return;
        }
        HttpResponse response = (HttpResponse)msg;
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());
        Throwable error = null;
        try {
            ctx.write(msg, prm);
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Error e) {
            Throwables.propagateIfFatal((Throwable)e);
            error = e;
            throw e;
        }
        finally {
            HttpServerRequest request = (HttpServerRequest)ctx.channel().attr(NettyHttpTracing.REQUEST_ATTRIBUTE).get();
            this.handler.handleSend((HttpServerResponse)new HttpResponseWrapper(request, response, error), span);
            scope.close();
        }
    }

    static final class HttpResponseWrapper
    extends HttpServerResponse {
        @Nullable
        final HttpServerRequest request;
        final HttpResponse delegate;
        @Nullable
        final Throwable error;

        HttpResponseWrapper(@Nullable HttpServerRequest request, HttpResponse response, @Nullable Throwable error) {
            this.request = request;
            this.delegate = response;
            this.error = error;
        }

        public HttpResponse unwrap() {
            return this.delegate;
        }

        @Nullable
        public HttpServerRequest request() {
            return this.request;
        }

        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            HttpResponseStatus status = this.delegate.status();
            return status != null ? status.code() : 0;
        }
    }

    static final class HttpRequestWrapper
    extends HttpServerRequest {
        final HttpRequest request;
        @Nullable
        final InetSocketAddress remoteAddress;

        HttpRequestWrapper(HttpRequest request, InetSocketAddress remoteAddress) {
            this.request = request;
            this.remoteAddress = remoteAddress;
        }

        public HttpRequest unwrap() {
            return this.request;
        }

        public boolean parseClientIpAndPort(Span span) {
            if (this.parseClientIpFromXForwardedFor(span)) {
                return true;
            }
            if (this.remoteAddress == null || this.remoteAddress.getAddress() == null) {
                return false;
            }
            return span.remoteIpAndPort(Platform.get().getHostString(this.remoteAddress), this.remoteAddress.getPort());
        }

        public String method() {
            return this.request.method().name();
        }

        public String path() {
            return URI.create(this.request.uri()).getPath();
        }

        public String url() {
            String host = this.header("Host");
            if (host == null) {
                return null;
            }
            return "http://" + host + this.request.uri();
        }

        public String header(String name) {
            return this.request.headers().get(name);
        }
    }
}

