/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.servlet;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.internal.Throwables;
import brave.jakarta.servlet.HttpServletRequestWrapper;
import brave.jakarta.servlet.HttpServletResponseWrapper;
import brave.jakarta.servlet.internal.ServletRuntime;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TracingFilter
implements Filter {
    final ServletRuntime servlet = ServletRuntime.get();
    final CurrentTraceContext currentTraceContext;
    final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;

    public static Filter create(Tracing tracing) {
        return new TracingFilter(HttpTracing.create((Tracing)tracing));
    }

    public static Filter create(HttpTracing httpTracing) {
        return new TracingFilter(httpTracing);
    }

    TracingFilter(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = this.servlet.httpServletResponse(response);
        TraceContext context = (TraceContext)request.getAttribute(TraceContext.class.getName());
        if (context != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(context);){
                chain.doFilter(request, response);
            }
            return;
        }
        Span span = this.handler.handleReceive((HttpServerRequest)new HttpServletRequestWrapper(req));
        request.setAttribute(SpanCustomizer.class.getName(), (Object)span.customizer());
        request.setAttribute(TraceContext.class.getName(), (Object)span.context());
        SendHandled sendHandled = new SendHandled();
        request.setAttribute(SendHandled.class.getName(), (Object)sendHandled);
        Throwable error = null;
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(span.context());
        try {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        catch (Throwable e) {
            Throwables.propagateIfFatal((Throwable)e);
            error = e;
            throw e;
        }
        finally {
            if (this.servlet.isAsync(req)) {
                this.servlet.handleAsync(this.handler, req, res, span);
            } else if (sendHandled.compareAndSet(false, true)) {
                HttpServerResponse responseWrapper = HttpServletResponseWrapper.create(req, res, error);
                this.handler.handleSend(responseWrapper, span);
            }
            scope.close();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
    }

    static final class SendHandled
    extends AtomicBoolean {
        SendHandled() {
        }
    }
}

