/*
 * Decompiled with CFR 0.152.
 */
package brave.servlet;

import brave.http.HttpServerAdapter;
import brave.servlet.ServletRuntime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import zipkin2.Endpoint;

public class HttpServletAdapter
extends HttpServerAdapter<HttpServletRequest, HttpServletResponse> {
    final ServletRuntime servlet = ServletRuntime.get();

    public HttpServletResponse adaptResponse(HttpServletRequest req, HttpServletResponse resp) {
        String httpRoute = (String)req.getAttribute("http.route");
        return httpRoute != null ? new DecoratedHttpServletResponse(resp, req.getMethod(), httpRoute) : resp;
    }

    public boolean parseClientAddress(HttpServletRequest req, Endpoint.Builder builder) {
        if (builder.parseIp(req.getHeader("X-Forwarded-For")) || builder.parseIp(req.getRemoteAddr())) {
            builder.port(req.getRemotePort());
            return true;
        }
        return false;
    }

    public String method(HttpServletRequest request) {
        return request.getMethod();
    }

    public String path(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public String url(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        if (request.getQueryString() != null && !request.getQueryString().isEmpty()) {
            url.append('?').append(request.getQueryString());
        }
        return url.toString();
    }

    public String requestHeader(HttpServletRequest request, String name) {
        return request.getHeader(name);
    }

    public String methodFromResponse(HttpServletResponse response) {
        if (response instanceof DecoratedHttpServletResponse) {
            return ((DecoratedHttpServletResponse)response).method;
        }
        return null;
    }

    public String route(HttpServletResponse response) {
        if (response instanceof DecoratedHttpServletResponse) {
            return ((DecoratedHttpServletResponse)response).httpRoute;
        }
        return null;
    }

    public Integer statusCode(HttpServletResponse response) {
        return this.servlet.status(response);
    }

    static class DecoratedHttpServletResponse
    extends HttpServletResponseWrapper {
        final String method;
        final String httpRoute;

        DecoratedHttpServletResponse(HttpServletResponse response, String method, String httpRoute) {
            super(response);
            this.method = method;
            this.httpRoute = httpRoute;
        }
    }
}

