/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.messaging.MessagingRequest;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import brave.spring.rabbit.MessageProducerRequest;
import brave.spring.rabbit.SpringRabbitTracing;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;

final class TracingMessagePostProcessor
implements MessagePostProcessor {
    final SpringRabbitTracing springRabbitTracing;
    final Tracing tracing;
    final Tracer tracer;
    final CurrentTraceContext currentTraceContext;
    final TraceContext.Extractor<MessageProducerRequest> extractor;
    final SamplerFunction<MessagingRequest> sampler;
    final TraceContext.Injector<MessageProducerRequest> injector;
    @Nullable
    final String remoteServiceName;

    TracingMessagePostProcessor(SpringRabbitTracing springRabbitTracing) {
        this.springRabbitTracing = springRabbitTracing;
        this.tracing = springRabbitTracing.tracing;
        this.tracer = this.tracing.tracer();
        this.currentTraceContext = this.tracing.currentTraceContext();
        this.extractor = springRabbitTracing.producerExtractor;
        this.sampler = springRabbitTracing.producerSampler;
        this.injector = springRabbitTracing.producerInjector;
        this.remoteServiceName = springRabbitTracing.remoteServiceName;
    }

    public Message postProcessMessage(Message message) {
        Span span;
        MessageProducerRequest request = new MessageProducerRequest(message);
        TraceContext maybeParent = this.currentTraceContext.get();
        if (maybeParent == null) {
            TraceContextOrSamplingFlags extracted = this.springRabbitTracing.extractAndClearHeaders(this.extractor, request, message);
            span = this.springRabbitTracing.nextMessagingSpan(this.sampler, (MessagingRequest)request, extracted);
        } else {
            span = this.tracer.newChild(maybeParent);
        }
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("publish");
            if (this.remoteServiceName != null) {
                span.remoteServiceName(this.remoteServiceName);
            }
            long timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
            span.start(timestamp).finish(timestamp);
        }
        this.injector.inject(span.context(), (Object)request);
        return message;
    }
}

