/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.libthrift;

import java.io.Closeable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TFramedTransport;
import zipkin2.reporter.libthrift.InternalScribeCodec;

final class ScribeClient
implements Closeable {
    static final Logger logger = Logger.getLogger(ScribeClient.class.getName());
    static final byte[] category = new byte[]{122, 105, 112, 107, 105, 110};
    final String host;
    final int port;
    final int socketTimeout;
    final int connectTimeout;
    volatile TSocket socket;
    volatile TBinaryProtocol prot;
    private int seqid_;

    ScribeClient(String host, int port, int socketTimeout, int connectTimeout) {
        this.host = host;
        this.port = port;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
    }

    static int messageSizeInBytes(int spanSizeInBytes) {
        return InternalScribeCodec.messageSizeInBytes(category, spanSizeInBytes);
    }

    static int messageSizeInBytes(List<byte[]> encodedSpans) {
        return InternalScribeCodec.messageSizeInBytes(category, encodedSpans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean log(List<byte[]> encodedSpans) throws TException {
        try {
            if (this.socket == null) {
                ScribeClient scribeClient = this;
                synchronized (scribeClient) {
                    if (this.socket == null) {
                        this.socket = new TSocket(new TConfiguration(), this.host, this.port, this.socketTimeout, this.connectTimeout);
                        this.prot = new TBinaryProtocol((TTransport)new TFramedTransport((TTransport)this.socket));
                    }
                }
            }
            if (!this.socket.isOpen()) {
                this.socket.open();
            }
            InternalScribeCodec.writeLogRequest(category, encodedSpans, ++this.seqid_, this.prot);
            this.prot.getTransport().flush();
            return InternalScribeCodec.readLogResponse(this.seqid_, this.prot);
        }
        catch (TTransportException e) {
            logger.log(Level.FINE, "Transport exception. recreating socket", e);
            this.close();
            this.seqid_ = 0;
            throw e;
        }
    }

    @Override
    public void close() {
        TSocket maybe = this.socket;
        if (maybe != null) {
            maybe.close();
        }
    }
}

