/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import java.util.Arrays;
import java.util.stream.Collectors;

public class FlywayVersion
implements Comparable<FlywayVersion> {
    private final int[] parts;

    public static FlywayVersion parseVersion(String version) {
        String[] split = version.split("\\.");
        int[] parts = Arrays.stream(split).mapToInt(Integer::parseInt).toArray();
        return new FlywayVersion(parts);
    }

    private FlywayVersion(int[] parts) {
        this.parts = parts;
    }

    public boolean isGreaterThan(String version) {
        return this.compareTo(FlywayVersion.parseVersion(version)) > 0;
    }

    public boolean isGreaterThanOrEqualTo(String version) {
        return this.compareTo(FlywayVersion.parseVersion(version)) >= 0;
    }

    public boolean isLessThan(String version) {
        return this.compareTo(FlywayVersion.parseVersion(version)) < 0;
    }

    public boolean isLessThanOrEqualTo(String version) {
        return this.compareTo(FlywayVersion.parseVersion(version)) <= 0;
    }

    @Override
    public int compareTo(FlywayVersion other) {
        for (int i = 0; i < this.parts.length || i < other.parts.length; ++i) {
            int otherPart;
            int thisPart = i < this.parts.length ? this.parts[i] : 0;
            int n = otherPart = i < other.parts.length ? other.parts[i] : 0;
            if (thisPart > otherPart) {
                return 1;
            }
            if (thisPart >= otherPart) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlywayVersion that = (FlywayVersion)o;
        return Arrays.equals(this.parts, that.parts);
    }

    public int hashCode() {
        return Arrays.hashCode(this.parts);
    }

    public String toString() {
        return Arrays.stream(this.parts).mapToObj(String::valueOf).collect(Collectors.joining("."));
    }
}

