/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import io.zonky.test.db.flyway.FlywayClassUtils;
import io.zonky.test.db.flyway.FlywayVersion;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class FlywayWrapper {
    private static final ClassLoader classLoader = FlywayWrapper.class.getClassLoader();
    private static final FlywayVersion flywayVersion = FlywayClassUtils.getFlywayVersion();
    private final Flyway flyway;
    private final Object config;

    public static FlywayWrapper newInstance() {
        if (flywayVersion.isGreaterThanOrEqualTo("6")) {
            Object config = ReflectionUtils.invokeStaticMethod(Flyway.class, "configure", new Object[0]);
            return new FlywayWrapper((Flyway)ReflectionUtils.invokeMethod(config, "load", new Object[0]));
        }
        return new FlywayWrapper((Flyway)ReflectionUtils.invokeConstructor(Flyway.class, new Object[0]));
    }

    public static FlywayWrapper forBean(Flyway flyway) {
        return new FlywayWrapper(flyway);
    }

    private FlywayWrapper(Flyway flyway) {
        this.flyway = flyway;
        this.config = flywayVersion.isGreaterThanOrEqualTo("5.1") ? ReflectionUtils.getField(AopTestUtils.getUltimateTargetObject((Object)flyway), "configuration") : AopTestUtils.getUltimateTargetObject((Object)flyway);
    }

    public Flyway getFlyway() {
        return this.flyway;
    }

    public Object getConfig() {
        if (flywayVersion.isGreaterThanOrEqualTo("9.9")) {
            Object modernConfig = ReflectionUtils.getField(this.config, "modernConfig");
            return ReflectionUtils.getField(modernConfig, "flyway");
        }
        return this.config;
    }

    public Object getEnvConfig() {
        if (flywayVersion.isGreaterThanOrEqualTo("9.16")) {
            return ReflectionUtils.invokeMethod(this.config, "getCurrentResolvedEnvironment", new Object[0]);
        }
        if (flywayVersion.isGreaterThanOrEqualTo("9.9")) {
            return ReflectionUtils.invokeMethod(this.config, "getCurrentEnvironment", new Object[0]);
        }
        return null;
    }

    public Object clean() {
        return ReflectionUtils.invokeMethod(this.flyway, "clean", new Object[0]);
    }

    public Object baseline() {
        return ReflectionUtils.invokeMethod(this.flyway, "baseline", new Object[0]);
    }

    public Object migrate() {
        return ReflectionUtils.invokeMethod(this.flyway, "migrate", new Object[0]);
    }

    public Collection<ResolvedMigration> getMigrations() {
        try {
            Flyway flyway = (Flyway)AopTestUtils.getUltimateTargetObject((Object)this.flyway);
            MigrationResolver resolver = this.createMigrationResolver(flyway);
            if (flywayVersion.isGreaterThanOrEqualTo("9")) {
                return (Collection)ReflectionUtils.invokeMethod(resolver, "resolveMigrations", this.config);
            }
            if (flywayVersion.isGreaterThanOrEqualTo("5.2")) {
                Class contextType = ClassUtils.forName((String)"org.flywaydb.core.api.resolver.Context", (ClassLoader)classLoader);
                Object contextInstance = ProxyFactory.getProxy((Class)contextType, (Interceptor)((MethodInterceptor)invocation -> "getConfiguration".equals(invocation.getMethod().getName()) ? this.config : invocation.proceed()));
                return (Collection)ReflectionUtils.invokeMethod(resolver, "resolveMigrations", contextInstance);
            }
            return (Collection)ReflectionUtils.invokeMethod(resolver, "resolveMigrations", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class not found: " + e.getMessage());
        }
    }

    private MigrationResolver createMigrationResolver(Flyway flyway) throws ClassNotFoundException {
        if (flywayVersion.isGreaterThanOrEqualTo("8")) {
            Object executor = ReflectionUtils.getField(flyway, "flywayExecutor");
            Object providers = ReflectionUtils.invokeMethod(executor, "createResourceAndClassProviders", true);
            Object resourceProvider = ReflectionUtils.getField(providers, "left");
            Object classProvider = ReflectionUtils.getField(providers, "right");
            Object sqlScriptFactory = FlywayWrapper.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptFactory");
            Object sqlScriptExecutorFactory = FlywayWrapper.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory");
            Object parsingContext = ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.parser.ParsingContext", new Object[0]);
            if (flywayVersion.isGreaterThanOrEqualTo("9")) {
                return (MigrationResolver)ReflectionUtils.invokeMethod(executor, "createMigrationResolver", resourceProvider, classProvider, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext, null);
            }
            return (MigrationResolver)ReflectionUtils.invokeMethod(executor, "createMigrationResolver", resourceProvider, classProvider, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext);
        }
        if (flywayVersion.isGreaterThanOrEqualTo("6.3")) {
            Object scanner = this.createScanner(flyway);
            Object sqlScriptFactory = FlywayWrapper.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptFactory");
            Object sqlScriptExecutorFactory = FlywayWrapper.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory");
            Object parsingContext = ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.parser.ParsingContext", new Object[0]);
            return (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", scanner, scanner, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext);
        }
        if (flywayVersion.isGreaterThanOrEqualTo("6")) {
            Object scanner = this.createScanner(flyway);
            Object sqlScriptFactory = FlywayWrapper.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptFactory");
            Object sqlScriptExecutorFactory = FlywayWrapper.createMock("org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory");
            return (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", scanner, scanner, sqlScriptExecutorFactory, sqlScriptFactory);
        }
        if (flywayVersion.isGreaterThanOrEqualTo("5.2")) {
            Object scanner = this.createScanner(flyway);
            Object placeholderReplacer = FlywayWrapper.createMock("org.flywaydb.core.internal.placeholder.PlaceholderReplacer");
            Object factory = ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.database.postgresql.PostgreSQLSqlStatementBuilderFactory", placeholderReplacer);
            return (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", null, scanner, scanner, factory);
        }
        if (flywayVersion.isGreaterThanOrEqualTo("5.1")) {
            Object scanner = this.createScanner(flyway);
            Object placeholderReplacer = ReflectionUtils.invokeMethod(flyway, "createPlaceholderReplacer", new Object[0]);
            return (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", null, scanner, placeholderReplacer);
        }
        if (flywayVersion.isGreaterThanOrEqualTo("4")) {
            Object scanner = this.createScanner(flyway);
            return (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", null, scanner);
        }
        return (MigrationResolver)ReflectionUtils.invokeMethod(flyway, "createMigrationResolver", new Object[]{null});
    }

    private Object createScanner(Flyway flyway) throws ClassNotFoundException {
        if (flywayVersion.isGreaterThanOrEqualTo("7.9")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(this.config, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(this.config, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(this.config, "getEncoding", new Object[0]), ReflectionUtils.invokeMethod(this.config, "getDetectEncoding", new Object[0]), false, ReflectionUtils.getField(flyway, "resourceNameCache"), ReflectionUtils.getField(flyway, "locationScannerCache"), ReflectionUtils.invokeMethod(this.config, "getFailOnMissingLocations", new Object[0]));
        }
        if (flywayVersion.isGreaterThanOrEqualTo("7")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(this.config, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(this.config, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(this.config, "getEncoding", new Object[0]), false, ReflectionUtils.getField(flyway, "resourceNameCache"), ReflectionUtils.getField(flyway, "locationScannerCache"));
        }
        if (flywayVersion.isGreaterThanOrEqualTo("6.3.3")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(this.config, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(this.config, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(this.config, "getEncoding", new Object[0]), ReflectionUtils.getField(flyway, "resourceNameCache"), ReflectionUtils.getField(flyway, "locationScannerCache"));
        }
        if (flywayVersion.isGreaterThanOrEqualTo("6.1")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(this.config, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(this.config, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(this.config, "getEncoding", new Object[0]), ReflectionUtils.getField(flyway, "resourceNameCache"));
        }
        if (flywayVersion.isGreaterThanOrEqualTo("6.0.3")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", (ClassLoader)classLoader), Arrays.asList((Object[])ReflectionUtils.invokeMethod(this.config, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(this.config, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(this.config, "getEncoding", new Object[0]));
        }
        if (flywayVersion.isGreaterThanOrEqualTo("5.2")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.scanner.Scanner", Arrays.asList((Object[])ReflectionUtils.invokeMethod(this.config, "getLocations", new Object[0])), ReflectionUtils.invokeMethod(this.config, "getClassLoader", new Object[0]), ReflectionUtils.invokeMethod(this.config, "getEncoding", new Object[0]));
        }
        if (flywayVersion.isGreaterThanOrEqualTo("5.1")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.util.scanner.Scanner", this.config);
        }
        if (flywayVersion.isGreaterThanOrEqualTo("4")) {
            return ReflectionUtils.invokeConstructor("org.flywaydb.core.internal.util.scanner.Scanner", ReflectionUtils.invokeMethod(this.config, "getClassLoader", new Object[0]));
        }
        throw new IllegalStateException("Unsupported flyway version: " + flywayVersion);
    }

    public DataSource getDataSource() {
        return (DataSource)FlywayWrapper.getValue(this.config, "getDataSource", new Object[0]);
    }

    public void setDataSource(DataSource dataSource) {
        FlywayWrapper.setValue(this.config, "setDataSource", dataSource);
    }

    public List<String> getLocations() {
        if (flywayVersion.isGreaterThanOrEqualTo("5.1")) {
            return ImmutableList.copyOf(Arrays.stream(FlywayWrapper.getArray(this.config, "getLocations", new Object[0])).map(location -> (String)ReflectionUtils.invokeMethod(location, "getDescriptor", new Object[0])).iterator());
        }
        return ImmutableList.copyOf(FlywayWrapper.getArray(this.config, "getLocations", new Object[0]));
    }

    public void setLocations(List<String> locations) {
        if (flywayVersion.isGreaterThanOrEqualTo("5.1")) {
            ReflectionUtils.invokeMethod(this.config, "setLocationsAsStrings", new Object[]{locations.toArray(new String[0])});
        } else {
            ReflectionUtils.invokeMethod(this.config, "setLocations", new Object[]{locations.toArray(new String[0])});
        }
    }

    public List<String> getSchemas() {
        return ImmutableList.copyOf(FlywayWrapper.getArray(this.config, "getSchemas", new Object[0]));
    }

    public void setSchemas(List<String> schemas) {
        FlywayWrapper.setValue(this.config, "setSchemas", schemas.toArray(new String[0]));
    }

    public String getTable() {
        return (String)FlywayWrapper.getValue(this.config, "getTable", new Object[0]);
    }

    public void setTable(String table) {
        FlywayWrapper.setValue(this.config, "setTable", table);
    }

    public String getSqlMigrationPrefix() {
        return (String)FlywayWrapper.getValue(this.config, "getSqlMigrationPrefix", new Object[0]);
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        FlywayWrapper.setValue(this.config, "setSqlMigrationPrefix", sqlMigrationPrefix);
    }

    public String getRepeatableSqlMigrationPrefix() {
        if (flywayVersion.isGreaterThanOrEqualTo("4")) {
            return (String)FlywayWrapper.getValue(this.config, "getRepeatableSqlMigrationPrefix", new Object[0]);
        }
        return "R";
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        if (flywayVersion.isGreaterThanOrEqualTo("4")) {
            FlywayWrapper.setValue(this.config, "setRepeatableSqlMigrationPrefix", repeatableSqlMigrationPrefix);
        } else if (!Objects.equals(repeatableSqlMigrationPrefix, this.getRepeatableSqlMigrationPrefix())) {
            throw new UnsupportedOperationException("This method is not supported in current Flyway version");
        }
    }

    public String getSqlMigrationSeparator() {
        return (String)FlywayWrapper.getValue(this.config, "getSqlMigrationSeparator", new Object[0]);
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        FlywayWrapper.setValue(this.config, "setSqlMigrationSeparator", sqlMigrationSeparator);
    }

    public List<String> getSqlMigrationSuffixes() {
        if (flywayVersion.isGreaterThanOrEqualTo("5")) {
            return ImmutableList.copyOf(FlywayWrapper.getArray(this.config, "getSqlMigrationSuffixes", new Object[0]));
        }
        return ImmutableList.of(FlywayWrapper.getValue(this.config, "getSqlMigrationSuffix", new Object[0]));
    }

    public void setSqlMigrationSuffixes(List<String> sqlMigrationSuffixes) {
        if (flywayVersion.isGreaterThanOrEqualTo("5")) {
            FlywayWrapper.setValue(this.config, "setSqlMigrationSuffixes", sqlMigrationSuffixes.toArray(new String[0]));
        } else if (sqlMigrationSuffixes.size() == 1) {
            FlywayWrapper.setValue(this.config, "setSqlMigrationSuffix", sqlMigrationSuffixes.get(0));
        } else {
            throw new IllegalArgumentException("Only a single element is supported for the current flyway version");
        }
    }

    public boolean isIgnoreMissingMigrations() {
        if (flywayVersion.isGreaterThanOrEqualTo("9")) {
            E[] patterns = FlywayWrapper.getArray(this.config, "getIgnoreMigrationPatterns", new Object[0]);
            return patterns.length > 0 && "*".equals(ReflectionUtils.getField(patterns[patterns.length - 1], "migrationType")) && "missing".equalsIgnoreCase((String)ReflectionUtils.getField(patterns[patterns.length - 1], "migrationState"));
        }
        if (flywayVersion.isGreaterThanOrEqualTo("4.1")) {
            return (Boolean)FlywayWrapper.getValue(this.config, "isIgnoreMissingMigrations", new Object[0]);
        }
        return false;
    }

    public void setIgnoreMissingMigrations(boolean ignoreMissingMigrations) {
        if (flywayVersion.isGreaterThanOrEqualTo("9")) {
            Object[] patterns = FlywayWrapper.getArray(this.config, "getIgnoreMigrationPatterns", new Object[0]);
            if (this.isIgnoreMissingMigrations() && !ignoreMissingMigrations) {
                FlywayWrapper.setValue(this.config, "setIgnoreMigrationPatterns", Arrays.copyOf(patterns, patterns.length - 1));
            } else if (!this.isIgnoreMissingMigrations() && ignoreMissingMigrations) {
                try {
                    Object ignorePattern = ReflectionUtils.invokeStaticMethod("org.flywaydb.core.api.pattern.ValidatePattern", "fromPattern", "*:missing");
                    FlywayWrapper.setValue(this.config, "setIgnoreMigrationPatterns", ObjectUtils.addObjectToArray((Object[])patterns, ignorePattern));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Class not found: " + e.getMessage());
                }
            }
        } else if (flywayVersion.isGreaterThanOrEqualTo("4.1")) {
            FlywayWrapper.setValue(this.config, "setIgnoreMissingMigrations", ignoreMissingMigrations);
        } else if (!Objects.equals(ignoreMissingMigrations, this.isIgnoreMissingMigrations())) {
            throw new UnsupportedOperationException("This method is not supported in current Flyway version");
        }
    }

    public boolean isIgnoreFutureMigrations() {
        if (flywayVersion.isGreaterThanOrEqualTo("4") && flywayVersion.isLessThan("9")) {
            return (Boolean)FlywayWrapper.getValue(this.config, "isIgnoreFutureMigrations", new Object[0]);
        }
        return true;
    }

    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        if (flywayVersion.isGreaterThanOrEqualTo("4") && flywayVersion.isLessThan("9")) {
            FlywayWrapper.setValue(this.config, "setIgnoreFutureMigrations", ignoreFutureMigrations);
        } else if (!Objects.equals(ignoreFutureMigrations, this.isIgnoreFutureMigrations())) {
            throw new UnsupportedOperationException("This method is not supported in current Flyway version");
        }
    }

    public boolean isValidateOnMigrate() {
        return (Boolean)FlywayWrapper.getValue(this.config, "isValidateOnMigrate", new Object[0]);
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        FlywayWrapper.setValue(this.config, "setValidateOnMigrate", validateOnMigrate);
    }

    public boolean isCleanDisabled() {
        return (Boolean)FlywayWrapper.getValue(this.config, "isCleanDisabled", new Object[0]);
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        FlywayWrapper.setValue(this.config, "setCleanDisabled", cleanDisabled);
    }

    public Object getResourceProvider() {
        if (flywayVersion.isGreaterThanOrEqualTo("6.5")) {
            return FlywayWrapper.getValue(this.config, "getResourceProvider", new Object[0]);
        }
        return null;
    }

    public void setResourceProvider(Object resourceProvider) {
        if (flywayVersion.isGreaterThanOrEqualTo("6.5")) {
            FlywayWrapper.setValue(this.config, "setResourceProvider", resourceProvider);
        } else if (!Objects.equals(resourceProvider, this.getResourceProvider())) {
            throw new UnsupportedOperationException("This method is not supported in current Flyway version");
        }
    }

    public Object getJavaMigrationClassProvider() {
        if (flywayVersion.isGreaterThanOrEqualTo("6.5")) {
            return FlywayWrapper.getValue(this.config, "getJavaMigrationClassProvider", new Object[0]);
        }
        return null;
    }

    public void setJavaMigrationClassProvider(Object javaMigrationClassProvider) {
        if (flywayVersion.isGreaterThanOrEqualTo("6.5")) {
            FlywayWrapper.setValue(this.config, "setJavaMigrationClassProvider", javaMigrationClassProvider);
        } else if (!Objects.equals(javaMigrationClassProvider, this.getJavaMigrationClassProvider())) {
            throw new UnsupportedOperationException("This method is not supported in current Flyway version");
        }
    }

    public List<Object> getJavaMigration() {
        if (flywayVersion.isGreaterThanOrEqualTo("6")) {
            return ImmutableList.copyOf(FlywayWrapper.getArray(this.config, "getJavaMigrations", new Object[0]));
        }
        return ImmutableList.of();
    }

    public void setJavaMigration(List<Object> javaMigrations) {
        if (flywayVersion.isGreaterThanOrEqualTo("6")) {
            try {
                Class javaMigrationType = ClassUtils.forName((String)"org.flywaydb.core.api.migration.JavaMigration", null);
                Object[] javaMigrationArray = (Object[])Array.newInstance(javaMigrationType, javaMigrations.size());
                FlywayWrapper.setValue(this.config, "setJavaMigrations", javaMigrations.toArray(javaMigrationArray));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class not found: " + e.getMessage());
            }
        } else if (!Objects.equals(javaMigrations, this.getJavaMigration())) {
            throw new UnsupportedOperationException("This method is not supported in current Flyway version");
        }
    }

    public List<Object> getCallbacks() {
        return ImmutableList.copyOf(FlywayWrapper.getArray(this.config, "getCallbacks", new Object[0]));
    }

    public void setCallbacks(List<Object> callbacks) {
        try {
            Class callbackType = flywayVersion.isGreaterThanOrEqualTo("5.1") ? ClassUtils.forName((String)"org.flywaydb.core.api.callback.Callback", null) : ClassUtils.forName((String)"org.flywaydb.core.api.callback.FlywayCallback", null);
            Object[] callbackArray = (Object[])Array.newInstance(callbackType, callbacks.size());
            FlywayWrapper.setValue(this.config, "setCallbacks", callbacks.toArray(callbackArray));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class not found: " + e.getMessage());
        }
    }

    public List<Object> getConfigurationExtensions() {
        if (flywayVersion.isGreaterThanOrEqualTo("9")) {
            try {
                Object pluginRegister = ReflectionUtils.getField(this.config, "pluginRegister");
                Class pluginType = ClassUtils.forName((String)"org.flywaydb.core.extensibility.ConfigurationExtension", (ClassLoader)classLoader);
                return ImmutableList.copyOf(FlywayWrapper.getList(pluginRegister, "getPlugins", pluginType));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class not found: " + e.getMessage());
            }
        }
        return ImmutableList.of();
    }

    private static <T> T getValue(Object target, String method, Object ... args) {
        return ReflectionUtils.invokeMethod(target, method, args);
    }

    private static <E> E[] getArray(Object target, String method, Object ... args) {
        return (Object[])ReflectionUtils.invokeMethod(target, method, args);
    }

    private static <E> List<E> getList(Object target, String method, Object ... args) {
        return (List)ReflectionUtils.invokeMethod(target, method, args);
    }

    private static void setValue(Object target, String method, Object value) {
        ReflectionUtils.invokeMethod(target, method, value);
    }

    private static Object createMock(String className) throws ClassNotFoundException {
        Class proxyInterface = ClassUtils.forName((String)className, (ClassLoader)classLoader);
        return ProxyFactory.getProxy((Class)proxyInterface, (Interceptor)((MethodInterceptor)invocation -> null));
    }
}

