/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.preparer;

import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;

public class CompositeDatabasePreparer
implements DatabasePreparer {
    private final List<DatabasePreparer> preparers;

    public CompositeDatabasePreparer(List<DatabasePreparer> preparers) {
        this.preparers = ImmutableList.copyOf(preparers);
    }

    public List<DatabasePreparer> getPreparers() {
        return this.preparers;
    }

    @Override
    public long estimatedDuration() {
        return this.preparers.stream().mapToLong(DatabasePreparer::estimatedDuration).sum();
    }

    @Override
    public void prepare(DataSource dataSource) throws SQLException {
        for (DatabasePreparer preparer : this.preparers) {
            preparer.prepare(dataSource);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeDatabasePreparer that = (CompositeDatabasePreparer)o;
        return Objects.equals(this.preparers, that.preparers);
    }

    public int hashCode() {
        return Objects.hash(this.preparers);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("preparers", this.preparers).toString();
    }
}

