/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.hsqldb;

import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.hsqldb.HSQLEmbeddedDatabase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.hsqldb.jdbcDriver;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public class HSQLDatabaseProvider
implements DatabaseProvider {
    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource();
        String databaseName = UUID.randomUUID().toString();
        dataSource.setDriverClass(jdbcDriver.class);
        dataSource.setUrl(String.format("jdbc:hsqldb:mem:%s", databaseName));
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        HSQLEmbeddedDatabase database = new HSQLEmbeddedDatabase((DataSource)dataSource, databaseName, () -> HSQLDatabaseProvider.shutdownDatabase((DataSource)dataSource, databaseName));
        try {
            if (preparer != null) {
                preparer.prepare(database);
            }
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
        return database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(HSQLDatabaseProvider.class);
    }

    private static void shutdownDatabase(DataSource dataSource, String dbName) {
        CompletableFuture.runAsync(() -> {
            try {
                HSQLDatabaseProvider.executeStatement(dataSource, "SHUTDOWN");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }

    private static void executeStatement(DataSource dataSource, String ddlStatement) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute(ddlStatement);
        }
    }
}

