/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.hsqldb;

import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import javax.sql.DataSource;

public class HSQLEmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final DataSource dataSource;
    private final String dbName;

    public HSQLEmbeddedDatabase(DataSource dataSource, String dbName, Runnable closeCallback) {
        super(closeCallback);
        this.dataSource = dataSource;
        this.dbName = dbName;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        return String.format("jdbc:hsqldb:mem:%s;user=sa", this.dbName);
    }

    public String getDatabaseName() {
        return this.dbName;
    }
}

