/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketState;
import org.springframework.util.Assert;

public abstract class AbstractTicket
implements Ticket,
TicketState {
    private final ExpirationPolicy expirationPolicy;
    private final String id;
    private final TicketGrantingTicket ticketGrantingTicket;
    private long lastTimeUsed;
    private long previousLastTimeUsed;
    private long creationTime;
    private int countOfUses;

    public AbstractTicket(String id, TicketGrantingTicket ticket, ExpirationPolicy expirationPolicy) {
        Assert.notNull((Object)expirationPolicy, (String)"expirationPolicy cannot be null");
        Assert.notNull((Object)id, (String)"id cannot be null");
        this.id = id;
        this.creationTime = System.currentTimeMillis();
        this.lastTimeUsed = System.currentTimeMillis();
        this.expirationPolicy = expirationPolicy;
        this.ticketGrantingTicket = ticket;
    }

    public final String getId() {
        return this.id;
    }

    protected final void updateState() {
        this.previousLastTimeUsed = this.lastTimeUsed;
        this.lastTimeUsed = System.currentTimeMillis();
        ++this.countOfUses;
    }

    public final int getCountOfUses() {
        return this.countOfUses;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final TicketGrantingTicket getGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public final long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public final long getPreviousTimeUsed() {
        return this.previousLastTimeUsed;
    }

    public final boolean isExpired() {
        return this.expirationPolicy.isExpired(this) || this.isExpiredInternal();
    }

    protected abstract boolean isExpiredInternal();

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

