/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.web.flow.util.ContextUtils;
import org.jasig.cas.web.util.WebUtils;
import org.springframework.util.Assert;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractLoginAction
extends AbstractAction {
    private static final String EVENT_AUTHENTICATION_REQUIRED = "authenticationRequired";
    private static final String EVENT_AUTHENTICATED_BUT_NO_SERVICE = "authenticatedButNoService";
    private static final String EVENT_GATEWAY = "gateway";
    private static final String EVENT_HAS_SERVICE = "hasService";
    private static final String EVENT_REDIRECT = "redirect";
    public static final String REQUEST_PARAM_GATEWAY = "gateway";
    public static final String REQUEST_ATTRIBUTE_TICKET_GRANTING_TICKET = "ticketGrantingTicketId";
    private CookieGenerator ticketGrantingTicketCookieGenerator;
    private CookieGenerator warnCookieGenerator;

    protected final Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = ContextUtils.getHttpServletRequest(context);
        String ticketGrantingTicketId = WebUtils.getCookieValue(request, this.ticketGrantingTicketCookieGenerator.getCookieName());
        String service = ContextUtils.getParameterAsString(context, "service");
        boolean gateway = ContextUtils.getParameterAsBoolean(context, "gateway");
        boolean renew = ContextUtils.getParameterAsBoolean(context, "renew");
        boolean warn = Boolean.valueOf(WebUtils.getCookieValue(request, this.warnCookieGenerator.getCookieName()));
        return this.doExecuteInternal(context, ticketGrantingTicketId, service, gateway, renew, warn);
    }

    protected final Event authenticationRequired() {
        return this.result(EVENT_AUTHENTICATION_REQUIRED);
    }

    protected final Event authenticatedButNoService() {
        return this.result(EVENT_AUTHENTICATED_BUT_NO_SERVICE);
    }

    protected final Event gateway() {
        return this.result("gateway");
    }

    protected final Event hasService() {
        return this.result(EVENT_HAS_SERVICE);
    }

    protected final Event redirect() {
        return this.result(EVENT_REDIRECT);
    }

    protected abstract Event doExecuteInternal(RequestContext var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    protected final void initAction() {
        Assert.notNull((Object)this.ticketGrantingTicketCookieGenerator, (String)"ticketGrantingTicketCookieGenerator cannot be null");
        Assert.notNull((Object)this.warnCookieGenerator, (String)"warnCookieGenerator cannot be null");
        this.initActionInternal();
    }

    public final void setTicketGrantingTicketCookieGenerator(CookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public final void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    protected final CookieGenerator getTicketGrantingTicketCookieGenerator() {
        return this.ticketGrantingTicketCookieGenerator;
    }

    protected void initActionInternal() {
    }
}

