/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.util.Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class ConnectivityCheck {
    private static final int LOCAL_PREFERENCE = 0;
    private static final int SERVER_REFLEXIVE_PREFERENCE = 42;
    private static final int PEER_REFLEXIVE_PREFERENCE = 84;
    private static final int RELAYED_PREFERENCE = 126;
    private short componentId;
    HashSet<Candidate> candidates;

    public ConnectivityCheck(short componentId) {
        this.componentId = componentId;
        this.candidates = new HashSet();
    }

    public void gatherCandidateAddresses() {
        int network = 0;
        this.candidates = new HashSet();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                while (iaddresses.hasMoreElements()) {
                    InetAddress iaddress = iaddresses.nextElement();
                    if (iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress()) continue;
                    Candidate local = new Candidate(new Address(iaddress.getAddress()), this.componentId, network++);
                    this.candidates.add(local);
                    DiscoveryTest test = new DiscoveryTest(iaddress, "127.0.0.1", 5036);
                    DiscoveryInfo di = test.test();
                    if (di.getPublicIP() == null) continue;
                    Candidate cand = new Candidate(new Address(di.getPublicIP().getAddress()), Candidate.CandidateType.ServerReflexive, this.componentId, local, network++);
                    cand.setComponentId(this.componentId);
                    this.candidates.add(cand);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void prioritizeCandidates() {
        int numberLocal = 0;
        int numberServerReflexive = 0;
        int numberPeerReflexive = 0;
        int numberRelayed = 0;
        for (Candidate cand : this.candidates) {
            Candidate.CandidateType type = cand.getCandidateType();
            if (type == Candidate.CandidateType.Local) {
                ++numberLocal;
                continue;
            }
            if (type == Candidate.CandidateType.ServerReflexive) {
                ++numberServerReflexive;
                continue;
            }
            if (type == Candidate.CandidateType.PeerReflexive) {
                ++numberPeerReflexive;
                continue;
            }
            if (type != Candidate.CandidateType.Relayed) continue;
            ++numberRelayed;
        }
        Iterator<Candidate> iterCandidates = this.candidates.iterator();
        while (iterCandidates.hasNext()) {
            int typeValue = 0;
            int localValue = 0;
            short componentValue = 0;
            Candidate cand = iterCandidates.next();
            Candidate.CandidateType type = cand.getCandidateType();
            if (type == Candidate.CandidateType.Local) {
                typeValue = 0;
                localValue = numberLocal--;
            } else if (type == Candidate.CandidateType.ServerReflexive) {
                typeValue = 42;
                localValue = numberServerReflexive--;
            } else if (type == Candidate.CandidateType.PeerReflexive) {
                typeValue = 84;
                localValue = numberPeerReflexive--;
            } else if (type == Candidate.CandidateType.Relayed) {
                typeValue = 126;
                localValue = numberRelayed--;
            }
            componentValue = cand.getComponentId();
            int priority = 26 * typeValue + 10 * localValue + componentValue;
            cand.setPriority(priority);
        }
    }

    public static void main(String[] args) {
        ConnectivityCheck cc = new ConnectivityCheck(1);
        cc.gatherCandidateAddresses();
    }
}

