/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.MediaNegotiator;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContentDescription;
import org.jivesoftware.smackx.packet.JingleError;

public class IncomingJingleSession
extends JingleSession {
    private final Accepting accepting;
    private final Pending pending;
    private final Active active;
    private JingleSessionRequest initialSessionRequest;

    protected IncomingJingleSession(XMPPConnection conn, String responder, List payloadTypes, JingleTransportManager transportManager, JingleSessionRequest initialJingleSessionRequest) throws XMPPException {
        super(conn, responder, conn.getUser());
        this.setSid(initialJingleSessionRequest.getSessionID());
        this.accepting = new Accepting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
        TransportResolver resolver = null;
        try {
            resolver = transportManager.getResolver(this);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
        this.setMediaNeg(new MediaNegotiator(this, payloadTypes));
        if (resolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
            this.setTransportNeg(new TransportNegotiator.RawUdp(this, resolver));
        }
        if (resolver.getType().equals((Object)TransportResolver.Type.ice)) {
            this.setTransportNeg(new TransportNegotiator.Ice(this, resolver));
        }
    }

    protected IncomingJingleSession(XMPPConnection conn, String responder, List payloadTypes, JingleTransportManager transportManager, JingleMediaManager jingleMediaManager, JingleSessionRequest initialJingleSessionRequest) throws XMPPException {
        this(conn, responder, payloadTypes, transportManager, initialJingleSessionRequest);
        this.jingleMediaManager = jingleMediaManager;
    }

    public void start(JingleSessionRequest initialJingleSessionRequest) throws XMPPException {
        this.setState(this.accepting);
        this.updatePacketListener();
        Jingle packet = initialJingleSessionRequest.getJingle();
        if (packet == null) {
            throw new XMPPException("Session request with null Jingle packet.");
        }
        this.setSid(packet.getSid());
        this.respond(packet);
    }

    public void start() throws XMPPException {
        this.start(this.getInitialSessionRequest());
    }

    public JingleSessionRequest getInitialSessionRequest() {
        return this.initialSessionRequest;
    }

    public void setInitialSessionRequest(JingleSessionRequest initialRequest) {
        this.initialSessionRequest = initialRequest;
    }

    public IQ sendFormattedError(JingleError error) {
        IQ perror = null;
        if (error != null) {
            perror = IncomingJingleSession.createIQ(this.getSid(), this.getInitiator(), this.getResponder(), IQ.Type.ERROR);
            perror.addExtension((PacketExtension)error);
            this.getConnection().sendPacket((Packet)perror);
            System.err.println(perror.toXML());
        }
        return perror;
    }

    public class Active
    extends JingleNegotiator.State {
        public Active(JingleNegotiator neg) {
            super(neg);
        }

        public void eventEnter() {
            PayloadType.Audio bestCommonAudioPt = IncomingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
            TransportCandidate bestRemoteCandidate = IncomingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
            TransportCandidate acceptedLocalCandidate = IncomingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate();
            IncomingJingleSession.this.triggerSessionEstablished(bestCommonAudioPt, bestRemoteCandidate, acceptedLocalCandidate);
            super.eventEnter();
        }

        public Jingle eventTerminate(Jingle jin) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jin);
        }

        public void eventError(IQ iq) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosedOnError(new XMPPException(iq.getError().getMessage()));
            super.eventError(iq);
        }
    }

    public class Pending
    extends JingleNegotiator.State {
        JingleMediaListener jingleMediaListener;
        JingleTransportListener jingleTransportListener;

        public Pending(JingleNegotiator neg) {
            super(neg);
            this.jingleMediaListener = new JingleMediaListener(){

                public void mediaClosed(PayloadType cand) {
                }

                public void mediaEstablished(PayloadType pt) {
                    Pending.this.checkFullyEstablished();
                }
            };
            this.jingleTransportListener = new JingleTransportListener(){

                public void transportEstablished(TransportCandidate local, TransportCandidate remote) {
                    Pending.this.checkFullyEstablished();
                }

                public void transportClosed(TransportCandidate cand) {
                }

                public void transportClosedOnError(XMPPException e) {
                }
            };
        }

        public void eventEnter() {
            IncomingJingleSession.this.addMediaListener(this.jingleMediaListener);
            IncomingJingleSession.this.addTransportListener(this.jingleTransportListener);
            super.eventEnter();
        }

        public void eventExit() {
            IncomingJingleSession.this.removeMediaListener(this.jingleMediaListener);
            IncomingJingleSession.this.removeTransportListener(this.jingleTransportListener);
            super.eventExit();
        }

        private void checkFullyEstablished() {
            if (IncomingJingleSession.this.isFullyEstablished()) {
                PayloadType.Audio bestCommonAudioPt = IncomingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
                TransportCandidate bestRemoteCandidate = IncomingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
                TransportCandidate acceptedLocalCandidate = IncomingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate();
                if (bestCommonAudioPt != null && bestRemoteCandidate != null && acceptedLocalCandidate != null) {
                    Jingle jout = new Jingle(Jingle.Action.SESSIONACCEPT);
                    jout.addDescription(new JingleContentDescription.Audio(new JingleContentDescription.JinglePayloadType(bestCommonAudioPt)));
                    jout.addTransport(IncomingJingleSession.this.getTransportNeg().getJingleTransport(bestRemoteCandidate));
                    IncomingJingleSession.this.addExpectedId(jout.getPacketID());
                    IncomingJingleSession.this.sendFormattedJingle(jout);
                }
            }
        }

        public Jingle eventAccept(Jingle jin) throws XMPPException {
            PayloadType.Audio acceptedPayloadType = null;
            TransportCandidate acceptedLocalCandidate = null;
            if (IncomingJingleSession.this.isFullyEstablished()) {
                acceptedPayloadType = IncomingJingleSession.this.getAcceptedAudioPayloadType(jin);
                acceptedLocalCandidate = IncomingJingleSession.this.getAcceptedLocalCandidate(jin);
                if (acceptedPayloadType != null && acceptedLocalCandidate != null) {
                    if (((PayloadType)acceptedPayloadType).equals(IncomingJingleSession.this.getMediaNeg().getBestCommonAudioPt()) && acceptedLocalCandidate.equals(IncomingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate())) {
                        IncomingJingleSession.this.setState(IncomingJingleSession.this.active);
                    }
                } else {
                    throw new JingleNegotiator.JingleException(JingleError.MALFORMED_STANZA);
                }
            }
            return super.eventAccept(jin);
        }

        public Jingle eventAck(IQ iq) throws XMPPException {
            IncomingJingleSession.this.setState(IncomingJingleSession.this.active);
            return super.eventAck(iq);
        }

        public void eventError(IQ iq) throws XMPPException {
            if (iq == null) {
                return;
            }
            IncomingJingleSession.this.triggerSessionClosedOnError(new XMPPException(iq.getError()));
            super.eventError(iq);
        }

        public Jingle eventTerminate(Jingle jin) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jin);
        }
    }

    public class Accepting
    extends JingleNegotiator.State {
        public Accepting(JingleNegotiator neg) {
            super(neg);
        }

        public Jingle eventInitiate(Jingle inJingle) throws XMPPException {
            IncomingJingleSession.this.setState(IncomingJingleSession.this.pending);
            return super.eventInitiate(inJingle);
        }

        public void eventError(IQ iq) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosedOnError(new JingleNegotiator.JingleException(iq.getError().getMessage()));
            super.eventError(iq);
        }

        public Jingle eventTerminate(Jingle jin) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jin);
        }
    }
}

