/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.MediaNegotiator;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContentDescription;
import org.jivesoftware.smackx.packet.JingleError;

public class OutgoingJingleSession
extends JingleSession {
    private final Inviting inviting;
    private final Pending pending;
    private final Active active;

    protected OutgoingJingleSession(XMPPConnection conn, String responder, List payloadTypes, JingleTransportManager transportManager) {
        super(conn, conn.getUser(), responder);
        this.setSid(OutgoingJingleSession.generateSessionId());
        this.inviting = new Inviting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
        TransportResolver resolver = null;
        try {
            resolver = transportManager.getResolver(this);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
        this.setMediaNeg(new MediaNegotiator(this, payloadTypes));
        if (resolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
            this.setTransportNeg(new TransportNegotiator.RawUdp(this, resolver));
        }
        if (resolver.getType().equals((Object)TransportResolver.Type.ice)) {
            this.setTransportNeg(new TransportNegotiator.Ice(this, resolver));
        }
    }

    protected OutgoingJingleSession(XMPPConnection conn, String responder, List payloadTypes, JingleTransportManager transportManager, JingleMediaManager jingleMediaManager) {
        this(conn, responder, payloadTypes, transportManager);
        this.jingleMediaManager = jingleMediaManager;
    }

    public void start(JingleSessionRequest req) throws IllegalStateException {
        if (this.invalidState()) {
            this.setState(this.inviting);
            try {
                this.updatePacketListener();
                this.respond(null);
            }
            catch (XMPPException e) {
                e.printStackTrace();
                this.close();
            }
        } else {
            throw new IllegalStateException("Starting session without null state.");
        }
    }

    public void start() throws IllegalStateException {
        this.start(null);
    }

    public IQ sendFormattedError(JingleError error) {
        IQ perror = null;
        if (error != null) {
            perror = OutgoingJingleSession.createIQ(this.getSid(), this.getResponder(), this.getInitiator(), IQ.Type.ERROR);
            perror.addExtension((PacketExtension)error);
            this.getConnection().sendPacket((Packet)perror);
            System.err.println(perror.toXML());
        }
        return perror;
    }

    public class Active
    extends JingleNegotiator.State {
        public Active(JingleNegotiator neg) {
            super(neg);
        }

        public void eventEnter() {
            PayloadType.Audio bestCommonAudioPt = OutgoingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
            TransportCandidate bestRemoteCandidate = OutgoingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
            TransportCandidate acceptedLocalCandidate = OutgoingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate();
            OutgoingJingleSession.this.triggerSessionEstablished(bestCommonAudioPt, bestRemoteCandidate, acceptedLocalCandidate);
            super.eventEnter();
        }

        public Jingle eventTerminate(Jingle jin) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jin);
        }

        public void eventError(IQ iq) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosedOnError(new XMPPException(iq.getError().getMessage()));
            super.eventError(iq);
        }
    }

    public class Pending
    extends JingleNegotiator.State {
        JingleMediaListener jingleMediaListener;
        JingleTransportListener jingleTransportListener;

        public Pending(JingleNegotiator neg) {
            super(neg);
            this.jingleMediaListener = new JingleMediaListener(){

                public void mediaClosed(PayloadType cand) {
                }

                public void mediaEstablished(PayloadType pt) {
                    Pending.this.checkFullyEstablished();
                }
            };
            this.jingleTransportListener = new JingleTransportListener(){

                public void transportEstablished(TransportCandidate local, TransportCandidate remote) {
                    Pending.this.checkFullyEstablished();
                }

                public void transportClosed(TransportCandidate cand) {
                }

                public void transportClosedOnError(XMPPException e) {
                }
            };
        }

        public void eventEnter() {
            OutgoingJingleSession.this.addMediaListener(this.jingleMediaListener);
            OutgoingJingleSession.this.addTransportListener(this.jingleTransportListener);
        }

        public void eventExit() {
            OutgoingJingleSession.this.removeMediaListener(this.jingleMediaListener);
            OutgoingJingleSession.this.removeTransportListener(this.jingleTransportListener);
        }

        private void checkFullyEstablished() {
            if (OutgoingJingleSession.this.isFullyEstablished()) {
                PayloadType.Audio bestCommonAudioPt = OutgoingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
                TransportCandidate bestRemoteCandidate = OutgoingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
                Jingle jout = new Jingle(Jingle.Action.SESSIONACCEPT);
                jout.addDescription(new JingleContentDescription.Audio(new JingleContentDescription.JinglePayloadType(bestCommonAudioPt)));
                jout.addTransport(OutgoingJingleSession.this.getTransportNeg().getJingleTransport(bestRemoteCandidate));
                OutgoingJingleSession.this.addExpectedId(jout.getPacketID());
                OutgoingJingleSession.this.sendFormattedJingle(jout);
            }
        }

        public Jingle eventAccept(Jingle jin) throws XMPPException {
            PayloadType.Audio acceptedPayloadType = null;
            TransportCandidate acceptedLocalCandidate = null;
            if (OutgoingJingleSession.this.isFullyEstablished()) {
                acceptedPayloadType = OutgoingJingleSession.this.getAcceptedAudioPayloadType(jin);
                acceptedLocalCandidate = OutgoingJingleSession.this.getAcceptedLocalCandidate(jin);
                if (acceptedPayloadType != null && acceptedLocalCandidate != null) {
                    if (((PayloadType)acceptedPayloadType).equals(OutgoingJingleSession.this.getMediaNeg().getBestCommonAudioPt()) && acceptedLocalCandidate.equals(OutgoingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate())) {
                        OutgoingJingleSession.this.setState(OutgoingJingleSession.this.active);
                    }
                } else {
                    throw new JingleNegotiator.JingleException(JingleError.NEGOTIATION_ERROR);
                }
            }
            return null;
        }

        public Jingle eventAck(IQ iq) {
            OutgoingJingleSession.this.setState(OutgoingJingleSession.this.active);
            return null;
        }

        public Jingle eventRedirect(Jingle jin) {
            String redirArg = null;
            OutgoingJingleSession.this.triggerSessionRedirect(redirArg);
            return null;
        }

        public Jingle eventTerminate(Jingle jin) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jin);
        }

        public void eventError(IQ iq) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosedOnError(new XMPPException(iq.getError().getMessage()));
            super.eventError(iq);
        }
    }

    public class Inviting
    extends JingleNegotiator.State {
        public Inviting(JingleNegotiator neg) {
            super(neg);
        }

        public Jingle eventInvite() {
            return new Jingle(Jingle.Action.SESSIONINITIATE);
        }

        public Jingle eventAck(IQ iq) {
            OutgoingJingleSession.this.setState(OutgoingJingleSession.this.pending);
            return null;
        }

        public void eventError(IQ iq) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionDeclined(null);
            super.eventError(iq);
        }

        public Jingle eventRedirect(Jingle jin) {
            String redirArg = null;
            OutgoingJingleSession.this.triggerSessionRedirect(redirArg);
            return null;
        }

        public Jingle eventTerminate(Jingle jin) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jin);
        }
    }
}

