/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.test.demo.ice.ICENegociator;
import de.javawi.jstun.util.UtilityException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Random;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.nat.BridgedResolver;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.RTPBridge;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;

public class ICEResolver
extends TransportResolver {
    XMPPConnection connection;
    Random random = new Random();
    long sid;
    String server = "stun.xten.net";
    int port = 3478;
    ICENegociator iceNegociator = null;

    public ICEResolver(XMPPConnection connection, String server, int port) {
        this.connection = connection;
        this.server = server;
        this.port = port;
        this.setType(TransportResolver.Type.ice);
    }

    public void initialize() throws XMPPException {
        if (!this.isResolving() && !this.isResolved()) {
            System.out.println("Initialized");
            this.iceNegociator = new ICENegociator(1, this.server, this.port);
            this.iceNegociator.gatherCandidateAddresses();
            this.iceNegociator.prioritizeCandidates();
        }
        this.setInitialized();
    }

    public void cancel() throws XMPPException {
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void resolve(JingleSession session) throws XMPPException {
        this.setResolveInit();
        for (TransportCandidate transportCandidate : this.getCandidatesList()) {
            if (!(transportCandidate instanceof ICECandidate)) continue;
            ICECandidate iceCandidate = (ICECandidate)transportCandidate;
            iceCandidate.removeCandidateEcho();
        }
        this.clear();
        for (Candidate candidate : this.iceNegociator.getSortedCandidates()) {
            try {
                Candidate.CandidateType type = candidate.getCandidateType();
                ICECandidate.Type iceType = ICECandidate.Type.local;
                iceType = type.equals((Object)Candidate.CandidateType.ServerReflexive) ? ICECandidate.Type.srflx : (type.equals((Object)Candidate.CandidateType.PeerReflexive) ? ICECandidate.Type.prflx : (type.equals((Object)Candidate.CandidateType.Relayed) ? ICECandidate.Type.relay : ICECandidate.Type.host));
                ICECandidate transportCandidate = new ICECandidate(candidate.getAddress().getInetAddress().getHostAddress(), 1, candidate.getNetwork(), String.valueOf(Math.abs(this.random.nextLong())), candidate.getPort(), "1", candidate.getPriority(), iceType);
                transportCandidate.setLocalIp(candidate.getBase().getAddress().getInetAddress().getHostAddress());
                transportCandidate.setPort(this.getFreePort());
                try {
                    transportCandidate.addCandidateEcho(session);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                this.addCandidate(transportCandidate);
                System.out.println("C: " + candidate.getAddress().getInetAddress() + "|" + candidate.getBase().getAddress().getInetAddress() + " p:" + candidate.getPriority());
            }
            catch (UtilityException e) {
                e.printStackTrace();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (RTPBridge.serviceAvailable(this.connection)) {
            String publicIp;
            try {
                void var3_10;
                String localIp;
                if (this.iceNegociator.getPublicCandidate() != null) {
                    localIp = this.iceNegociator.getPublicCandidate().getBase().getAddress().getInetAddress().getHostAddress();
                    int n = this.iceNegociator.getPublicCandidate().getNetwork();
                } else {
                    localIp = BridgedResolver.getLocalHost();
                    boolean bl = false;
                }
                this.sid = Math.abs(this.random.nextLong());
                RTPBridge rtpBridge = RTPBridge.getRTPBridge(this.connection, String.valueOf(this.sid));
                ICECandidate localCandidate = new ICECandidate(rtpBridge.getIp(), 1, (int)var3_10, String.valueOf(Math.abs(this.random.nextLong())), rtpBridge.getPortA(), "1", 0, ICECandidate.Type.relay);
                localCandidate.setLocalIp(localIp);
                ICECandidate remoteCandidate = new ICECandidate(rtpBridge.getIp(), 1, (int)var3_10, String.valueOf(Math.abs(this.random.nextLong())), rtpBridge.getPortB(), "1", 0, ICECandidate.Type.relay);
                remoteCandidate.setLocalIp(localIp);
                localCandidate.setSymmetric(remoteCandidate);
                remoteCandidate.setSymmetric(localCandidate);
                localCandidate.setPassword(rtpBridge.getPass());
                remoteCandidate.setPassword(rtpBridge.getPass());
                localCandidate.setSessionId(rtpBridge.getSid());
                remoteCandidate.setSessionId(rtpBridge.getSid());
                localCandidate.setConnection(this.connection);
                remoteCandidate.setConnection(this.connection);
                this.addCandidate(localCandidate);
            }
            catch (UtilityException e) {
                e.printStackTrace();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            if (this.iceNegociator.getPublicCandidate() == null && (publicIp = RTPBridge.getPublicIP(this.connection)) != null && !publicIp.equals("")) {
                void var3_13;
                Object var3_11 = null;
                try {
                    Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                boolean found = false;
                block16: while (var3_13.hasMoreElements()) {
                    NetworkInterface iface = (NetworkInterface)var3_13.nextElement();
                    Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                    while (iaddresses.hasMoreElements()) {
                        InetAddress iaddress = iaddresses.nextElement();
                        if (iaddress.getHostAddress().indexOf(publicIp) <= -1) continue;
                        found = true;
                        continue block16;
                    }
                }
                if (!found) {
                    try {
                        ICECandidate publicCandidate = new ICECandidate(publicIp, 1, 0, String.valueOf(Math.abs(this.random.nextLong())), this.getFreePort(), "1", 0, ICECandidate.Type.srflx);
                        publicCandidate.setLocalIp(InetAddress.getLocalHost().getHostAddress());
                        try {
                            publicCandidate.addCandidateEcho(session);
                        }
                        catch (SocketException e) {
                            e.printStackTrace();
                        }
                        this.addCandidate(publicCandidate);
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.setResolveEnd();
    }
}

