/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jgroups.util.Streamable;

public class DrawCommand
implements Streamable {
    static final byte DRAW = 1;
    static final byte CLEAR = 2;
    byte mode;
    int x = 0;
    int y = 0;
    int r = 0;
    int g = 0;
    int b = 0;

    public DrawCommand() {
    }

    DrawCommand(byte mode) {
        this.mode = mode;
    }

    DrawCommand(byte mode, int x, int y, int r, int g, int b) {
        this.mode = mode;
        this.x = x;
        this.y = y;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.mode);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.r);
        out.writeInt(this.g);
        out.writeInt(this.b);
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.mode = in.readByte();
        this.x = in.readInt();
        this.y = in.readInt();
        this.r = in.readInt();
        this.g = in.readInt();
        this.b = in.readInt();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        switch (this.mode) {
            case 1: {
                ret.append("DRAW(" + this.x + ", " + this.y + ") [" + this.r + '|' + this.g + '|' + this.b + ']');
                break;
            }
            case 2: {
                ret.append("CLEAR");
                break;
            }
            default: {
                return "<undefined>";
            }
        }
        return ret.toString();
    }
}

