/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;

public class STATS
extends Protocol {
    long sent_msgs;
    long sent_bytes;
    long sent_ucasts;
    long sent_mcasts;
    long received_ucasts;
    long received_mcasts;
    long received_msgs;
    long received_bytes;
    long sent_ucast_bytes;
    long sent_mcast_bytes;
    long received_ucast_bytes;
    long received_mcast_bytes;
    HashMap sent = new HashMap();
    HashMap received = new HashMap();
    static final short UP = 1;
    static final short DOWN = 2;

    public String getName() {
        return "STATS";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.down_thread = false;
        this.up_thread = false;
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void resetStats() {
        this.received_mcasts = 0L;
        this.received_ucasts = 0L;
        this.sent_mcasts = 0L;
        this.sent_ucasts = 0L;
        this.sent_bytes = 0L;
        this.sent_msgs = 0L;
        this.received_mcast_bytes = 0L;
        this.received_ucast_bytes = 0L;
        this.sent_mcast_bytes = 0L;
        this.sent_ucast_bytes = 0L;
        this.received_bytes = 0L;
        this.received_msgs = 0L;
        this.sent.clear();
        this.received.clear();
    }

    public long getSentMessages() {
        return this.sent_msgs;
    }

    public long getSentBytes() {
        return this.sent_bytes;
    }

    public long getSentUnicastMessages() {
        return this.sent_ucasts;
    }

    public long getSentUnicastBytes() {
        return this.sent_ucast_bytes;
    }

    public long getSentMcastMessages() {
        return this.sent_mcasts;
    }

    public long getSentMcastBytes() {
        return this.sent_mcast_bytes;
    }

    public long getReceivedMessages() {
        return this.received_msgs;
    }

    public long getReceivedBytes() {
        return this.received_bytes;
    }

    public long getReceivedUnicastMessages() {
        return this.received_ucasts;
    }

    public long getReceivedUnicastBytes() {
        return this.received_ucast_bytes;
    }

    public long getReceivedMcastMessages() {
        return this.received_mcasts;
    }

    public long getReceivedMcastBytes() {
        return this.received_mcast_bytes;
    }

    public void up(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            this.updateStats(msg, (short)1);
        } else if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            this.updateStats(msg, (short)2);
        } else if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        this.passDown(evt);
    }

    public String printStats() {
        Object val;
        Object key;
        Map.Entry entry;
        StringBuffer sb = new StringBuffer();
        sb.append("sent:\n");
        Iterator it = this.sent.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = entry.getKey();
            if (key == null) {
                key = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        it = this.received.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = entry.getKey();
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        return sb.toString();
    }

    private void handleViewChange(View view) {
        Vector members = view.getMembers();
        LinkedHashSet<Object> tmp = new LinkedHashSet<Object>(members);
        tmp.add(null);
        this.sent.keySet().retainAll(tmp);
        this.received.keySet().retainAll(tmp);
    }

    private void updateStats(Message msg, short direction) {
        boolean mcast;
        if (msg == null) {
            return;
        }
        int length = msg.getLength();
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        boolean bl = mcast = dest == null || dest.isMulticastAddress();
        if (direction == 1) {
            ++this.received_msgs;
            this.received_bytes += (long)length;
            if (mcast) {
                ++this.received_mcasts;
                this.received_mcast_bytes += (long)length;
            } else {
                ++this.received_ucasts;
                this.received_ucast_bytes += (long)length;
            }
        } else {
            ++this.sent_msgs;
            this.sent_bytes += (long)length;
            if (mcast) {
                ++this.sent_mcasts;
                this.sent_mcast_bytes += (long)length;
            } else {
                ++this.sent_ucasts;
                this.sent_ucast_bytes += (long)length;
            }
        }
        Address key = direction == 1 ? src : dest;
        HashMap map = direction == 1 ? this.received : this.sent;
        Entry entry = (Entry)map.get(key);
        if (entry == null) {
            entry = new Entry();
            map.put(key, entry);
        }
        ++entry.msgs;
        entry.bytes += (long)length;
        if (mcast) {
            ++entry.mcasts;
            entry.mcast_bytes += (long)length;
        } else {
            ++entry.ucasts;
            entry.ucast_bytes += (long)length;
        }
    }

    static class Entry {
        long msgs;
        long bytes;
        long ucasts;
        long mcasts;
        long ucast_bytes;
        long mcast_bytes;

        Entry() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.msgs).append(" (").append(this.bytes).append(" bytes)");
            sb.append(": ").append(this.ucasts).append(" ucasts (").append(this.ucast_bytes).append(" bytes), ");
            sb.append(this.mcasts).append(" mcasts (").append(this.mcast_bytes).append(" bytes)");
            return sb.toString();
        }
    }
}

