/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.MessageAcks;
import org.jgroups.protocols.SavedMessages;
import org.jgroups.protocols.TotalRetransmissionThread;
import org.jgroups.stack.Protocol;

public class TOTAL_OLD
extends Protocol {
    private static final String PROTOCOL_NAME = "TOTAL_OLD";
    private Address local_addr = null;
    private Vector members = new Vector();
    private long next_seq_id = -1L;
    private long next_seq_id_to_assign = -1L;
    private static final long INIT_SEQ_ID = 10L;
    private final SavedMessages queued_messages = new SavedMessages();
    private MessageAcks ack_history = null;
    private final TotalRetransmissionThread retrans_thread = new TotalRetransmissionThread(this);
    final Log log = LogFactory.getLog((Class)TOTAL_OLD.class);
    private final long last_request_time = -1L;
    static /* synthetic */ Class class$org$jgroups$protocols$TOTAL_OLD$TotalHeader;

    public String getName() {
        return PROTOCOL_NAME;
    }

    public void start() throws Exception {
        this.retrans_thread.start();
    }

    public void stop() {
        this.retrans_thread.stopResendRequests();
    }

    public void reset() {
        this.next_seq_id = -1L;
        this.queued_messages.clearMessages();
        this.retrans_thread.reset();
    }

    protected long getNextSeqID() {
        return this.next_seq_id;
    }

    protected long getFirstQueuedSeqID() {
        return this.queued_messages.getFirstSeq();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Address) {
                    this.local_addr = (Address)temp_obj;
                    break;
                }
                this.log.error((Object)"Error: Total.up() - could not cast local address to an Address object");
                break;
            }
            case 1: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Message) {
                    Message msg = (Message)temp_obj;
                    if ((temp_obj = msg.removeHeader(this.getName())) instanceof TotalHeader) {
                        TotalHeader hdr = (TotalHeader)temp_obj;
                        switch (hdr.total_header_type) {
                            case 0: {
                                this.passUp(evt);
                                return;
                            }
                            case 1: {
                                this.handleBCastMessage(msg, hdr.seq_id);
                                return;
                            }
                            case 2: {
                                if (!this.isSequencer()) return;
                                this.handleRequestMessage(msg);
                                return;
                            }
                            case 3: {
                                this.next_seq_id = hdr.seq_id;
                                return;
                            }
                            case 5: {
                                if (!this.isSequencer()) return;
                                temp_obj = msg.getSrc();
                                if (temp_obj instanceof Address) {
                                    this.ack_history.setSeq((Address)temp_obj, hdr.seq_id);
                                    return;
                                }
                                this.log.error((Object)"Error: TOTAL_OLD.Up() - could not cast source of message to an Address object (case TotalHeader.TOTAL_CUM_SEQ_ACK)");
                                return;
                            }
                            case 7: {
                                if (!this.isSequencer()) return;
                                this.handleResendRequest(msg, hdr.seq_id);
                                return;
                            }
                            default: {
                                this.log.error((Object)("Error: TOTAL_OLD.up() - unrecognized TotalHeader in message - " + hdr.toString()));
                                return;
                            }
                        }
                    } else {
                        this.log.error((Object)"Error: TOTAL_OLD.up() - could not cast message header to TotalHeader (case Event.MSG)");
                    }
                    return;
                } else {
                    this.log.error((Object)"Error: TOTAL_OLD.up() - could not cast argument of Event to a Message (case Event.MSG)");
                }
                return;
            }
            case 6: 
            case 15: {
                System.out.println("View Change event passed up to TOTAL_OLD (debug - mms21)");
                View new_view = (View)evt.getArg();
                this.members = new_view.getMembers();
                System.out.println("New view members (printed in TOTAL_OLD):");
                int view_size = this.members.size();
                for (int i = 0; i < view_size; ++i) {
                    System.out.println("  " + this.members.elementAt(i).toString());
                }
                this.reset();
                if (!this.isSequencer()) break;
                this.log.error((Object)"TOTAL_OLD.up() - I am the sequencer of this new view");
                this.ack_history = new MessageAcks(this.members);
                this.next_seq_id_to_assign = 10L;
                Message new_view_msg = new Message(null, this.local_addr, null);
                new_view_msg.putHeader(this.getName(), new TotalHeader(3, this.next_seq_id_to_assign));
                this.passDown(new Event(1, new_view_msg));
                break;
            }
        }
        this.passUp(evt);
    }

    private synchronized int passUpMessages() {
        if (this.next_seq_id < 0L) {
            return 0;
        }
        long lowest_seq_stored = this.queued_messages.getFirstSeq();
        if (lowest_seq_stored < 0L) {
            return 0;
        }
        if (lowest_seq_stored < this.next_seq_id) {
            this.log.error((Object)("Error: TOTAL_OLD.passUpMessages() - next expected sequence id (" + this.next_seq_id + ") is greater than the sequence id of a stored message (" + lowest_seq_stored + ')'));
            return 0;
        }
        if (this.next_seq_id == lowest_seq_stored) {
            Message msg = this.queued_messages.getFirstMessage();
            if (msg == null) {
                this.log.error((Object)"Error: TOTAL_OLD.passUpMessages() - unexpected null Message retrieved from stored messages");
                return 0;
            }
            this.passUp(new Event(1, msg));
            ++this.next_seq_id;
            return 1 + this.passUpMessages();
        }
        return 0;
    }

    private synchronized void handleBCastMessage(Message msg, long seq) {
        if (seq < this.next_seq_id) {
            return;
        }
        this.queued_messages.insertMessage(msg, seq);
        int num_passed = this.passUpMessages();
        if (num_passed > 1) {
            this.log.error((Object)("TOTAL_OLD.handleBCastMessage() - " + num_passed + " message(s) passed up the Protocol Stack"));
        }
    }

    private synchronized void handleRequestMessage(Message msg) {
        if (this.next_seq_id_to_assign < 0L) {
            this.log.error((Object)"Error: TOTAL_OLD.handleRequestMessage() - cannot handle request... do not know what sequence id to assign");
            return;
        }
        msg.setDest(null);
        msg.setSrc(this.local_addr);
        msg.putHeader(this.getName(), new TotalHeader(1, this.next_seq_id_to_assign));
        Message msg_copy = msg.copy();
        this.ack_history.addMessage(msg_copy, this.next_seq_id_to_assign);
        Header header = msg_copy.getHeader(this.getName());
        if (!(header instanceof TotalHeader)) {
            this.log.error((Object)("Error: TOTAL_OLD.handleRequestMessage() - BAD: stored message that did not contain a TotalHeader - " + this.next_seq_id_to_assign));
        }
        ++this.next_seq_id_to_assign;
        this.passDown(new Event(1, msg));
    }

    private synchronized void handleResendRequest(Message msg, long seq) {
        this.log.error((Object)("TOTAL_OLD.handleRequestMessage() - received resend request for message " + seq));
        Address requester = null;
        Message resend_msg = this.ack_history.getMessage(seq);
        if (resend_msg == null) {
            this.log.error((Object)("TOTAL_OLD.handleResendRequest() - could not find the message " + seq + " in the history to resend"));
            return;
        }
        resend_msg.setDest(requester);
        Header header = resend_msg.getHeader(this.getName());
        if (!(header instanceof TotalHeader)) {
            this.log.error((Object)("TOTAL_OLD: resend msg BAD (header is NOT a TotalHeader) - " + seq));
        }
        this.passDown(new Event(1, resend_msg));
        this.log.error((Object)("TOTAL_OLD.handleResendRequest() - responded to resend request for message " + seq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.log.error((Object)"NOTE: VIEW_CHANGE Event going down through TOTAL_OLD");
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int i = 0; i < new_members.size(); ++i) {
                            this.members.addElement(new_members.elementAt(i));
                        }
                    }
                    break;
                }
            }
            case 1: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Message) {
                    Message msg = (Message)temp_obj;
                    if (msg.getDest() == null) {
                        Address sequencer = this.getSequencer();
                        if (sequencer != null) {
                            msg.setDest(sequencer);
                        }
                        msg.putHeader(this.getName(), new TotalHeader(2, -1L));
                        break;
                    }
                    msg.putHeader(this.getName(), new TotalHeader(0, -1L));
                    break;
                }
                this.log.error((Object)"Error: TOTAL_OLD.down() - could not cast argument of Event to a Message (case Event.MSG)");
                break;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSequencer() {
        if (this.local_addr == null) {
            this.log.error((Object)"TOTAL_OLD.isSequencer() - local address unknown!");
            return false;
        }
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                this.log.error((Object)"TOTAL_OLD.isSequencer() - no members!");
                return false;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                Address seq_addr = (Address)temp_obj;
                return this.local_addr.equals(seq_addr);
            }
            this.log.error((Object)"Error: TOTAL_OLD.isSequencer() - could not cast element of \"members\" to an Address");
            return false;
        }
    }

    protected Address getLocalAddr() {
        return this.local_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address getSequencer() {
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                this.log.error((Object)"TOTAL_OLD.getSequencer() - no members");
                return null;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                return (Address)temp_obj;
            }
            this.log.error((Object)"Error: TOTAL_OLD.getSequencer() - could not cast first element of \"members\" to an Address");
            return null;
        }
    }

    public static class TotalHeader
    extends Header {
        public static final int TOTAL_UNICAST = 0;
        public static final int TOTAL_BCAST = 1;
        public static final int TOTAL_REQUEST = 2;
        public static final int TOTAL_NEW_VIEW = 3;
        public static final int TOTAL_NEW_VIEW_ACK = 4;
        public static final int TOTAL_CUM_SEQ_ACK = 5;
        public static final int TOTAL_SEQ_ACK = 6;
        public static final int TOTAL_RESEND = 7;
        public int total_header_type;
        final Log log = LogFactory.getLog((Class)(class$org$jgroups$protocols$TOTAL_OLD$TotalHeader == null ? (class$org$jgroups$protocols$TOTAL_OLD$TotalHeader = TOTAL_OLD.class$("org.jgroups.protocols.TOTAL_OLD$TotalHeader")) : class$org$jgroups$protocols$TOTAL_OLD$TotalHeader));
        public long seq_id;

        public TotalHeader() {
        }

        public TotalHeader(int type, long seq) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.total_header_type = type;
                    break;
                }
                default: {
                    this.log.error((Object)("Error: TotalHeader.TotalHeader() - unknown TotalHeader type given: " + type));
                    this.total_header_type = -1;
                }
            }
            this.seq_id = seq;
        }

        public String toString() {
            String type = "";
            switch (this.total_header_type) {
                case 0: {
                    type = "TOTAL_UNICAST";
                    break;
                }
                case 1: {
                    type = "TOTAL_BCAST";
                    break;
                }
                case 2: {
                    type = "TOTAL_REQUEST";
                    break;
                }
                case 3: {
                    type = "NEW_VIEW";
                    break;
                }
                case 4: {
                    type = "NEW_VIEW_ACK";
                    break;
                }
                case 5: {
                    type = "TOTAL_CUM_SEQ_ACK";
                    break;
                }
                case 6: {
                    type = "TOTAL_SEQ_ACK";
                    break;
                }
                case 7: {
                    type = "TOTAL_RESEND";
                    break;
                }
                default: {
                    type = "UNKNOWN TYPE (" + this.total_header_type + ')';
                }
            }
            return "[ TOTAL_OLD: type=" + type + ", seq=" + this.seq_id + " ]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.total_header_type);
            out.writeLong(this.seq_id);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total_header_type = in.readInt();
            this.seq_id = in.readLong();
        }
    }
}

