/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PerfHeader;
import org.jgroups.protocols.PerfObserver;
import org.jgroups.stack.Protocol;

public class PERF
extends Protocol {
    boolean details = false;
    final Vector members = new Vector();
    Vector protocols = null;
    static final String name = "PERF";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("details");
        if (str != null) {
            this.details = Boolean.valueOf(str);
            props.remove("details");
        }
        if (props.size() > 0) {
            this.log.error((Object)("PERF.setProperties(): these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.protocols = this.stack != null ? this.stack.getProtocols() : null;
        this.setupObservers();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                PerfHeader hdr = this.removePerfHeader(msg);
                if (hdr == null) break;
                hdr.setEndTime();
                hdr.setDone(name, 1);
                if (!this.trace) break;
                this.log.trace((Object)(hdr.printContents(this.details, this.protocols) + "\n---------------------------------\n"));
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    this.members.addAll(new_members);
                }
                this.passDown(evt);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                this.initializeMessage(msg);
            }
        }
        this.passDown(evt);
    }

    void setupObservers() {
        Protocol p = null;
        PerfObserver po = null;
        for (int i = 0; i < this.protocols.size(); ++i) {
            p = (Protocol)this.protocols.elementAt(i);
            String pname = p.getName();
            if (pname == null) continue;
            po = new PerfObserver(pname);
            p.setObserver(po);
        }
    }

    void initializeMessage(Message msg) {
        PerfHeader hdr = new PerfHeader(msg.getSrc(), msg.getDest());
        String pname = null;
        if (this.protocols == null) {
            this.log.error((Object)"PERF.initializeMessage(): 'protocols' variable is null");
            return;
        }
        for (int i = 0; i < this.protocols.size(); ++i) {
            Protocol p = (Protocol)this.protocols.elementAt(i);
            pname = p.getName();
            if (pname == null) continue;
            hdr.addEntry(pname);
        }
        hdr.setReceived(name, 2);
        msg.putHeader(name, hdr);
    }

    PerfHeader removePerfHeader(Message m) {
        Header hdr = null;
        if (m == null || (hdr = m.removeHeader(name)) == null) {
            return null;
        }
        return (PerfHeader)hdr;
    }
}

