/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Event;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator {
    protected static final Log log = LogFactory.getLog(Configurator.class);

    public static Protocol setupProtocolStack(String configuration, ProtocolStack st) throws Exception {
        Protocol protocol_stack = null;
        Vector<ProtocolConfiguration> protocol_configs = Configurator.parseConfigurations(configuration);
        Vector<Protocol> protocols = Configurator.createProtocols(protocol_configs, st);
        if (protocols == null) {
            return null;
        }
        protocol_stack = Configurator.connectProtocols(protocols);
        return protocol_stack;
    }

    public static void initProtocolStack(Protocol bottom_prot) throws Exception {
        while (bottom_prot != null) {
            bottom_prot.init();
            bottom_prot = bottom_prot.getUpProtocol();
        }
    }

    public static void startProtocolStack(Protocol prot) throws Exception {
        while (prot != null) {
            prot.start();
            prot = prot.getDownProtocol();
        }
    }

    public static void stopProtocolStack(Protocol prot) {
        while (prot != null) {
            prot.stop();
            prot = prot.getDownProtocol();
        }
    }

    public static void destroyProtocolStack(Protocol start_prot) {
        while (start_prot != null) {
            start_prot.destroy();
            start_prot = start_prot.getDownProtocol();
        }
    }

    public static Protocol findProtocol(Protocol prot_stack, String name) {
        Protocol curr_prot = prot_stack;
        while (true) {
            String s;
            if ((s = curr_prot.getName()) == null) {
                continue;
            }
            if (s.equals(name)) {
                return curr_prot;
            }
            if ((curr_prot = curr_prot.getDownProtocol()) == null) break;
        }
        return null;
    }

    public static Protocol getBottommostProtocol(Protocol prot_stack) {
        Protocol tmp = null;
        Protocol curr_prot = prot_stack;
        while ((tmp = curr_prot.getDownProtocol()) != null) {
            curr_prot = tmp;
        }
        return curr_prot;
    }

    public static Protocol createProtocol(String prot_spec, ProtocolStack stack) throws Exception {
        if (prot_spec == null) {
            throw new Exception("Configurator.createProtocol(): prot_spec is null");
        }
        ProtocolConfiguration config = new ProtocolConfiguration(prot_spec);
        Protocol prot = config.createLayer(stack);
        prot.init();
        return prot;
    }

    public static void insertProtocol(Protocol prot, int position, String neighbor_prot, ProtocolStack stack) throws Exception {
        if (neighbor_prot == null) {
            throw new Exception("Configurator.insertProtocol(): neighbor_prot is null");
        }
        if (position != 1 && position != 2) {
            throw new Exception("position has to be ABOVE or BELOW");
        }
        Protocol neighbor = stack.findProtocol(neighbor_prot);
        if (neighbor == null) {
            throw new Exception("protocol \"" + neighbor_prot + "\" not found in " + stack.printProtocolSpec(false));
        }
        if (position == 2) {
            prot.setUpProtocol(neighbor);
            Protocol below = neighbor.getDownProtocol();
            prot.setDownProtocol(below);
            if (below != null) {
                below.setUpProtocol(prot);
            }
            neighbor.setDownProtocol(prot);
        } else {
            Protocol above = neighbor.getUpProtocol();
            prot.setUpProtocol(above);
            if (above != null) {
                above.setDownProtocol(prot);
            }
            prot.setDownProtocol(neighbor);
            neighbor.setUpProtocol(prot);
        }
    }

    public static Protocol removeProtocol(Protocol top_prot, String prot_name) throws Exception {
        if (prot_name == null) {
            return null;
        }
        Protocol prot = Configurator.findProtocol(top_prot, prot_name);
        if (prot == null) {
            return null;
        }
        Protocol above = prot.getUpProtocol();
        Protocol below = prot.getDownProtocol();
        if (above != null) {
            above.setDownProtocol(below);
        }
        if (below != null) {
            below.setUpProtocol(above);
        }
        prot.setUpProtocol(null);
        prot.setDownProtocol(null);
        return prot;
    }

    private static Protocol connectProtocols(Vector protocol_list) {
        Protocol current_layer = null;
        Protocol next_layer = null;
        for (int i = 0; i < protocol_list.size(); ++i) {
            current_layer = (Protocol)protocol_list.elementAt(i);
            if (i + 1 >= protocol_list.size()) break;
            next_layer = (Protocol)protocol_list.elementAt(i + 1);
            current_layer.setUpProtocol(next_layer);
            next_layer.setDownProtocol(current_layer);
        }
        return current_layer;
    }

    public static Vector<String> parseProtocols(String config_str) throws IOException {
        Vector<String> retval = new Vector<String>();
        PushbackReader reader = new PushbackReader(new StringReader(config_str));
        boolean running = true;
        block0: while (running) {
            String protocol_name = Configurator.readWord(reader);
            StringBuilder sb = new StringBuilder();
            sb.append(protocol_name);
            int ch = Configurator.read(reader);
            if (ch == -1) {
                retval.add(sb.toString());
                break;
            }
            if (ch == 58) {
                retval.add(sb.toString());
                continue;
            }
            if (ch == 40) {
                reader.unread(ch);
                String attrs = Configurator.readUntil(reader, ')');
                sb.append(attrs);
                retval.add(sb.toString());
            } else {
                retval.add(sb.toString());
            }
            while ((ch = Configurator.read(reader)) != 58) {
                if (ch != -1) continue;
                running = false;
                continue block0;
            }
        }
        reader.close();
        return retval;
    }

    private static int read(Reader reader) throws IOException {
        int ch = -1;
        while ((ch = reader.read()) != -1) {
            if (Character.isWhitespace(ch)) continue;
            return ch;
        }
        return ch;
    }

    public static Vector<ProtocolConfiguration> parseConfigurations(String configuration) throws Exception {
        Vector<ProtocolConfiguration> retval = new Vector<ProtocolConfiguration>();
        Vector<String> protocol_string = Configurator.parseProtocols(configuration);
        if (protocol_string == null) {
            return null;
        }
        for (int i = 0; i < protocol_string.size(); ++i) {
            String component_string = protocol_string.elementAt(i);
            ProtocolConfiguration protocol_config = new ProtocolConfiguration(component_string);
            retval.addElement(protocol_config);
        }
        return retval;
    }

    private static String readUntil(Reader reader, char c) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = Configurator.read(reader)) != -1) {
            sb.append((char)ch);
            if (ch != c) continue;
            break;
        }
        return sb.toString();
    }

    private static String readWord(PushbackReader reader) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = Configurator.read(reader)) != -1) {
            if (Character.isLetterOrDigit(ch) || ch == 95 || ch == 46 || ch == 36) {
                sb.append((char)ch);
                continue;
            }
            reader.unread(ch);
            break;
        }
        return sb.toString();
    }

    private static Vector<Protocol> createProtocols(Vector<ProtocolConfiguration> protocol_configs, ProtocolStack stack) throws Exception {
        Vector<Protocol> retval = new Vector<Protocol>();
        for (int i = 0; i < protocol_configs.size(); ++i) {
            ProtocolConfiguration protocol_config = protocol_configs.elementAt(i);
            Protocol layer = protocol_config.createLayer(stack);
            if (layer == null) {
                return null;
            }
            retval.addElement(layer);
        }
        Configurator.sanityCheck(retval);
        return retval;
    }

    public static void sanityCheck(Vector<Protocol> protocols) throws Exception {
        ProtocolReq req;
        int j;
        Protocol prot;
        int i;
        Vector<String> names = new Vector<String>();
        Vector<ProtocolReq> req_list = new Vector<ProtocolReq>();
        for (i = 0; i < protocols.size(); ++i) {
            prot = protocols.elementAt(i);
            String name = prot.getName();
            for (j = 0; j < names.size(); ++j) {
                if (!name.equals(names.elementAt(j))) continue;
                throw new Exception("Configurator.sanityCheck(): protocol name " + name + " has been used more than once; protocol names have to be unique !");
            }
            names.addElement(name);
        }
        for (i = 0; i < protocols.size(); ++i) {
            prot = protocols.elementAt(i);
            req = new ProtocolReq(prot.getName());
            req.up_reqs = prot.requiredUpServices();
            req.down_reqs = prot.requiredDownServices();
            req.up_provides = prot.providedUpServices();
            req.down_provides = prot.providedDownServices();
            req_list.addElement(req);
        }
        for (i = 0; i < req_list.size(); ++i) {
            int evt_type;
            req = (ProtocolReq)req_list.elementAt(i);
            if (req.up_reqs != null) {
                for (j = 0; j < req.up_reqs.size(); ++j) {
                    evt_type = (Integer)req.up_reqs.elementAt(j);
                    if (Configurator.providesDownServices(i, req_list, evt_type)) continue;
                    throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + req.name + ", but not provided by any of the layers above");
                }
            }
            if (req.down_reqs == null) continue;
            for (j = 0; j < req.down_reqs.size(); ++j) {
                evt_type = (Integer)req.down_reqs.elementAt(j);
                if (Configurator.providesUpServices(i, req_list, evt_type)) continue;
                throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + req.name + ", but not provided by any of the layers below");
            }
        }
    }

    static boolean providesUpServices(int end_index, Vector req_list, int evt_type) {
        for (int i = 0; i < end_index; ++i) {
            ProtocolReq req = (ProtocolReq)req_list.elementAt(i);
            if (!req.providesUpService(evt_type)) continue;
            return true;
        }
        return false;
    }

    static boolean providesDownServices(int start_index, Vector req_list, int evt_type) {
        for (int i = start_index; i < req_list.size(); ++i) {
            ProtocolReq req = (ProtocolReq)req_list.elementAt(i);
            if (!req.providesDownService(evt_type)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Configurator <string>");
            System.exit(0);
        }
        String config_str = args[0];
        Configurator conf = new Configurator();
        Vector<Protocol> protocols = null;
        try {
            Vector<ProtocolConfiguration> protocol_configs = Configurator.parseConfigurations(config_str);
            protocols = Configurator.createProtocols(protocol_configs, null);
            if (protocols == null) {
                return;
            }
            Protocol protocol_stack = Configurator.connectProtocols(protocols);
            Thread.sleep(3000L);
            Configurator.destroyProtocolStack(protocol_stack);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        System.err.println(protocols);
    }

    public static class ProtocolConfiguration {
        private String protocol_name = null;
        private String properties_str = null;
        private final Properties properties = new Properties();
        private static final String protocol_prefix = "org.jgroups.protocols";

        public ProtocolConfiguration(String config_str) throws Exception {
            this.setContents(config_str);
        }

        public ProtocolConfiguration() {
        }

        public String getProtocolName() {
            return this.protocol_name;
        }

        public void setProtocolName(String name) {
            this.protocol_name = name;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setPropertiesString(String props) {
            this.properties_str = props;
        }

        void setContents(String config_str) throws Exception {
            int index = config_str.indexOf(40);
            int end_index = config_str.lastIndexOf(41);
            if (index == -1) {
                this.protocol_name = config_str;
            } else {
                if (end_index == -1) {
                    throw new Exception("Configurator.ProtocolConfiguration.setContents(): closing ')' not found in " + config_str + ": properties cannot be set !");
                }
                this.properties_str = config_str.substring(index + 1, end_index);
                this.protocol_name = config_str.substring(0, index);
            }
            if (this.properties_str != null) {
                String[] components = this.properties_str.split(";");
                for (int i = 0; i < components.length; ++i) {
                    String comp = components[i];
                    index = comp.indexOf(61);
                    if (index == -1) {
                        throw new Exception("Configurator.ProtocolConfiguration.setContents(): '=' not found in " + comp);
                    }
                    String name = comp.substring(0, index);
                    String value = comp.substring(index + 1, comp.length());
                    this.properties.put(name, value);
                }
            }
        }

        private Protocol createLayer(ProtocolStack prot_stack) throws Exception {
            Protocol retval = null;
            if (this.protocol_name == null) {
                return null;
            }
            String defaultProtocolName = "org.jgroups.protocols." + this.protocol_name;
            Class clazz = null;
            try {
                clazz = Util.loadClass(defaultProtocolName, this.getClass());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    clazz = Util.loadClass(this.protocol_name, this.getClass());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (clazz == null) {
                    throw new Exception("unable to load class for protocol " + this.protocol_name + " (either as an absolute - " + this.protocol_name + " - or relative - " + defaultProtocolName + " - package name)!");
                }
            }
            try {
                retval = (Protocol)clazz.newInstance();
                if (retval == null) {
                    throw new Exception("creation of instance for protocol " + this.protocol_name + "failed !");
                }
                retval.setProtocolStack(prot_stack);
                if (this.properties != null && !retval.setPropertiesInternal(this.properties)) {
                    throw new IllegalArgumentException("the following properties in " + this.protocol_name + " are not recognized: " + this.properties);
                }
            }
            catch (InstantiationException inst_ex) {
                log.error((Object)("an instance of " + this.protocol_name + " could not be created. Please check that it implements" + " interface Protocol and that is has a public empty constructor !"));
                throw inst_ex;
            }
            return retval;
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append("Protocol: ");
            if (this.protocol_name == null) {
                retval.append("<unknown>");
            } else {
                retval.append(this.protocol_name);
            }
            if (this.properties != null) {
                retval.append("(" + this.properties + ')');
            }
            return retval.toString();
        }
    }

    private static class ProtocolReq {
        Vector up_reqs = null;
        Vector down_reqs = null;
        Vector up_provides = null;
        Vector down_provides = null;
        String name = null;

        ProtocolReq(String name) {
            this.name = name;
        }

        boolean providesUpService(int evt_type) {
            if (this.up_provides != null) {
                for (int i = 0; i < this.up_provides.size(); ++i) {
                    int type = (Integer)this.up_provides.elementAt(i);
                    if (type != evt_type) continue;
                    return true;
                }
            }
            return false;
        }

        boolean providesDownService(int evt_type) {
            if (this.down_provides != null) {
                for (int i = 0; i < this.down_provides.size(); ++i) {
                    int type = (Integer)this.down_provides.elementAt(i);
                    if (type != evt_type) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append('\n' + this.name + ':');
            if (this.up_reqs != null) {
                ret.append("\nRequires from above: " + this.printUpReqs());
            }
            if (this.down_reqs != null) {
                ret.append("\nRequires from below: " + this.printDownReqs());
            }
            if (this.up_provides != null) {
                ret.append("\nProvides to above: " + this.printUpProvides());
            }
            if (this.down_provides != null) {
                ret.append("\nProvides to below: ").append(this.printDownProvides());
            }
            return ret.toString();
        }

        String printUpReqs() {
            StringBuffer ret = new StringBuffer("[");
            if (this.up_reqs != null) {
                for (int i = 0; i < this.up_reqs.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.up_reqs.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }

        String printDownReqs() {
            StringBuilder ret = new StringBuilder("[");
            if (this.down_reqs != null) {
                for (int i = 0; i < this.down_reqs.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.down_reqs.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }

        String printUpProvides() {
            StringBuilder ret = new StringBuilder("[");
            if (this.up_provides != null) {
                for (int i = 0; i < this.up_provides.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.up_provides.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }

        String printDownProvides() {
            StringBuilder ret = new StringBuilder("[");
            if (this.down_provides != null) {
                for (int i = 0; i < this.down_provides.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.down_provides.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }
    }
}

