/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Distributions;

import arjuna.JavaSim.Distributions.RandomStream;
import java.io.IOException;

public class HyperExponentialStream
extends RandomStream {
    private double Mean;
    private double StandardDeviation;
    private double p;

    public HyperExponentialStream(double m, double sd) {
        this.Mean = m;
        this.StandardDeviation = sd;
        double cv = this.StandardDeviation / this.Mean;
        double z = cv * cv;
        this.p = 0.5 * (1.0 - Math.sqrt((z - 1.0) / (z + 1.0)));
    }

    public HyperExponentialStream(double m, double sd, int StreamSelect) {
        this.Mean = m;
        this.StandardDeviation = sd;
        double cv = this.StandardDeviation / this.Mean;
        double z = cv * cv;
        this.p = 0.5 * (1.0 - Math.sqrt((z - 1.0) / (z + 1.0)));
        for (int ss = 0; ss < StreamSelect * 1000; ++ss) {
            this.Uniform();
        }
    }

    public HyperExponentialStream(double m, double sd, int StreamSelect, long MGSeed, long LCGSeed) {
        super(MGSeed, LCGSeed);
        this.Mean = m;
        this.StandardDeviation = sd;
        double cv = this.StandardDeviation / this.Mean;
        double z = cv * cv;
        this.p = 0.5 * (1.0 - Math.sqrt((z - 1.0) / (z + 1.0)));
        for (int ss = 0; ss < StreamSelect * 1000; ++ss) {
            this.Uniform();
        }
    }

    public double getNumber() throws IOException, ArithmeticException {
        double z = 0.0;
        z = this.Uniform() > this.p ? this.Mean / (1.0 - this.p) : this.Mean / this.p;
        return -0.5 * z * Math.log(this.Uniform());
    }
}

