/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Distributions;

import arjuna.JavaSim.Distributions.RandomStream;
import java.io.IOException;

public class NormalStream
extends RandomStream {
    private double Mean;
    private double StandardDeviation;
    private double z;

    public NormalStream(double m, double sd) {
        this.Mean = m;
        this.StandardDeviation = sd;
        this.z = 0.0;
    }

    public NormalStream(double m, double sd, int StreamSelect) {
        this.Mean = m;
        this.StandardDeviation = sd;
        this.z = 0.0;
        for (int ss = 0; ss < StreamSelect * 1000; ++ss) {
            this.Uniform();
        }
    }

    public NormalStream(double m, double sd, int StreamSelect, long MGSeed, long LCGSeed) {
        super(MGSeed, LCGSeed);
        this.Mean = m;
        this.StandardDeviation = sd;
        this.z = 0.0;
        for (int ss = 0; ss < StreamSelect * 1000; ++ss) {
            this.Uniform();
        }
    }

    public double getNumber() throws IOException, ArithmeticException {
        double X2;
        if (this.z != 0.0) {
            X2 = this.z;
            this.z = 0.0;
        } else {
            double v2;
            double v1;
            double S;
            while ((S = (v1 = 2.0 * this.Uniform() - 1.0) * v1 + (v2 = 2.0 * this.Uniform() - 1.0) * v2) >= 1.0) {
            }
            S = Math.sqrt(-2.0 * Math.log(S) / S);
            X2 = v1 * S;
            this.z = v2 * S;
        }
        return this.Mean + X2 * this.StandardDeviation;
    }
}

