/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Simulation;

import arjuna.JavaSim.Simulation.RestartException;
import arjuna.JavaSim.Simulation.Scheduler;
import arjuna.JavaSim.Simulation.Semaphore;
import arjuna.JavaSim.Simulation.SimulationException;
import arjuna.JavaSim.Simulation.SimulationProcess;
import arjuna.JavaSim.Simulation.TriggerQueue;

public class SimulationEntity
extends SimulationProcess {
    protected SimulationEntity _isWaiting = null;
    private boolean _interrupted = false;
    private boolean _triggered = false;
    private boolean _waiting = false;

    public void finalize() {
        super.finalize();
    }

    public void Interrupt(SimulationEntity toInterrupt, boolean immediate) throws SimulationException, RestartException {
        if (toInterrupt.terminated()) {
            throw new SimulationException("Entity already terminated.");
        }
        if (!toInterrupt._waiting) {
            throw new SimulationException("Entity not waiting.");
        }
        toInterrupt._interrupted = true;
        Scheduler.unschedule(toInterrupt);
        toInterrupt.ReActivateAt(SimulationProcess.CurrentTime(), true);
        if (immediate) {
            this.ReActivateAt(SimulationProcess.CurrentTime());
        }
    }

    public final void trigger() {
        this._triggered = true;
    }

    public void terminate() {
        if (this._isWaiting != null) {
            try {
                this._isWaiting.Cancel();
                this._isWaiting.ReActivateAt(SimulationProcess.CurrentTime(), true);
            }
            catch (RestartException e) {
            }
            catch (SimulationException simulationException) {
                // empty catch block
            }
            this._isWaiting = null;
        }
        super.terminate();
    }

    protected SimulationEntity() {
    }

    protected void Wait(double waitTime) throws SimulationException, RestartException, InterruptedException {
        this._waiting = true;
        try {
            this.Hold(waitTime);
        }
        catch (SimulationException e) {
            throw new SimulationException("Invalid entity.");
        }
        this._waiting = false;
        if (this._interrupted) {
            this._interrupted = false;
            throw new InterruptedException();
        }
    }

    protected void WaitFor(SimulationEntity controller, boolean reAct) throws SimulationException, RestartException, InterruptedException {
        if (controller == this) {
            throw new SimulationException("WaitFor cannot wait on self.");
        }
        controller._isWaiting = this;
        try {
            if (reAct) {
                controller.ReActivateAt(SimulationProcess.CurrentTime(), true);
            }
        }
        catch (SimulationException simulationException) {
            // empty catch block
        }
        this._waiting = true;
        this.Cancel();
        this._interrupted = false;
        this._waiting = false;
        if (!controller.terminated()) {
            throw new InterruptedException();
        }
    }

    protected void WaitFor(SimulationEntity controller) throws SimulationException, RestartException, InterruptedException {
        this.WaitFor(controller, false);
    }

    protected void WaitForTrigger(TriggerQueue _queue) throws SimulationException, RestartException, InterruptedException {
        _queue.insert(this);
        this._interrupted = false;
        this._waiting = true;
        this.Cancel();
        if (!this._triggered) {
            throw new InterruptedException();
        }
        this._triggered = false;
    }

    protected void WaitForSemaphore(Semaphore _sem) throws RestartException {
        _sem.Get(this);
    }
}

