/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Simulation;

import arjuna.JavaSim.Simulation.RestartException;
import arjuna.JavaSim.Simulation.Scheduler;
import arjuna.JavaSim.Simulation.SimulationException;
import arjuna.JavaSim.Simulation.SimulationProcessList;
import java.util.NoSuchElementException;

public class SimulationProcess
extends Thread {
    public static final int Never = -1;
    protected static SimulationProcessList allProcesses = new SimulationProcessList();
    private double wakeuptime = -1.0;
    private boolean Terminated = false;
    private boolean Passivated = true;
    private boolean started = false;
    private Object mutex = new Object();
    private int count = 1;
    private static Thread mainThread = null;
    static SimulationProcess Current = null;

    public void finalize() {
        if (!this.Terminated) {
            this.Terminated = true;
            this.Passivated = true;
            this.wakeuptime = -1.0;
            if (!this.idle()) {
                Scheduler.unschedule(this);
            }
            if (this == Current) {
                try {
                    Scheduler.schedule();
                }
                catch (SimulationException simulationException) {
                    // empty catch block
                }
            }
            allProcesses.Remove(this);
        }
    }

    public final double Time() {
        return SimulationProcess.CurrentTime();
    }

    public synchronized SimulationProcess next_ev() throws SimulationException, NoSuchElementException {
        if (!this.idle()) {
            return Scheduler.ReadyQueue.getNext(this);
        }
        throw new SimulationException("SimulationProcess not on run queue.");
    }

    public final double evtime() {
        return this.wakeuptime;
    }

    public void ActivateBefore(SimulationProcess p) throws SimulationException, RestartException {
        if (this.Terminated || !this.idle()) {
            return;
        }
        this.Passivated = false;
        if (!Scheduler.ReadyQueue.InsertBefore(this, p)) {
            throw new SimulationException("'before' process is not scheduled.");
        }
        this.wakeuptime = p.wakeuptime;
    }

    public void ActivateAfter(SimulationProcess p) throws SimulationException, RestartException {
        if (this.Terminated || !this.idle()) {
            return;
        }
        this.Passivated = false;
        if (!Scheduler.ReadyQueue.InsertAfter(this, p)) {
            throw new SimulationException("'after' process is not scheduled.");
        }
        this.wakeuptime = p.wakeuptime;
    }

    public void ActivateAt(double AtTime, boolean prior) throws SimulationException, RestartException {
        if (this.Terminated || !this.idle()) {
            return;
        }
        if (AtTime < SimulationProcess.CurrentTime()) {
            throw new SimulationException("Invalid time " + AtTime);
        }
        this.Passivated = false;
        this.wakeuptime = AtTime;
        Scheduler.ReadyQueue.Insert(this, prior);
    }

    public void ActivateAt(double AtTime) throws SimulationException, RestartException {
        this.ActivateAt(AtTime, false);
    }

    public void ActivateDelay(double Delay, boolean prior) throws SimulationException, RestartException {
        if (this.Terminated || !this.idle()) {
            return;
        }
        if (!this.checkTime(Delay)) {
            throw new SimulationException("Invalid delay time " + Delay);
        }
        this.Passivated = false;
        this.wakeuptime = Scheduler.SimulatedTime + Delay;
        Scheduler.ReadyQueue.Insert(this, prior);
    }

    public void ActivateDelay(double Delay) throws SimulationException, RestartException {
        this.ActivateDelay(Delay, false);
    }

    public void Activate() throws SimulationException, RestartException {
        if (this.Terminated || !this.idle()) {
            return;
        }
        this.Passivated = false;
        this.wakeuptime = SimulationProcess.CurrentTime();
        Scheduler.ReadyQueue.Insert(this, true);
    }

    public void ReActivateBefore(SimulationProcess p) throws SimulationException, RestartException {
        if (!this.idle()) {
            Scheduler.unschedule(this);
        }
        this.ActivateBefore(p);
        if (Current == this) {
            this.Suspend();
        }
    }

    public void ReActivateAfter(SimulationProcess p) throws SimulationException, RestartException {
        if (!this.idle()) {
            Scheduler.unschedule(this);
        }
        this.ActivateAfter(p);
        if (Current == this) {
            this.Suspend();
        }
    }

    public void ReActivateAt(double AtTime, boolean prior) throws SimulationException, RestartException {
        if (!this.idle()) {
            Scheduler.unschedule(this);
        }
        this.ActivateAt(AtTime, prior);
        if (Current == this) {
            this.Suspend();
        }
    }

    public void ReActivateAt(double AtTime) throws SimulationException, RestartException {
        this.ReActivateAt(AtTime, false);
    }

    public void ReActivateDelay(double Delay, boolean prior) throws SimulationException, RestartException {
        if (!this.idle()) {
            Scheduler.unschedule(this);
        }
        this.ActivateDelay(Delay, prior);
        if (Current == this) {
            this.Suspend();
        }
    }

    public void ReActivateDelay(double Delay) throws SimulationException, RestartException {
        this.ReActivateDelay(Delay, false);
    }

    public void ReActivate() throws SimulationException, RestartException {
        if (!this.idle()) {
            Scheduler.unschedule(this);
        }
        this.Activate();
        if (Current == this) {
            this.Suspend();
        }
    }

    public void Cancel() throws RestartException {
        if (!this.idle()) {
            if (this == Current) {
                this.wakeuptime = -1.0;
                this.Passivated = true;
                this.Suspend();
            } else {
                Scheduler.unschedule(this);
            }
        }
    }

    public void terminate() {
        if (!this.Terminated) {
            this.Passivated = true;
            this.Terminated = true;
            this.wakeuptime = -1.0;
            if (this != Current && !this.idle()) {
                Scheduler.unschedule(this);
            }
            try {
                Scheduler.schedule();
            }
            catch (SimulationException simulationException) {
                // empty catch block
            }
            allProcesses.Remove(this);
            this.stop();
        }
    }

    public synchronized boolean idle() {
        return !(this.wakeuptime >= SimulationProcess.CurrentTime());
    }

    public boolean passivated() {
        return this.Passivated;
    }

    public boolean terminated() {
        return this.Terminated;
    }

    public static SimulationProcess current() throws SimulationException {
        if (Current == null) {
            throw new SimulationException("Current not set.");
        }
        return Current;
    }

    public static double CurrentTime() {
        return Scheduler.SimulatedTime;
    }

    public static void mainSuspend() {
        mainThread = Thread.currentThread();
        mainThread.suspend();
    }

    public static void mainResume() throws SimulationException {
        if (mainThread == null) {
            throw new SimulationException("No main thread");
        }
        mainThread.resume();
    }

    protected SimulationProcess() {
        allProcesses.Insert(this);
    }

    protected void set_evtime(double time) throws SimulationException {
        if (!this.idle()) {
            if (!(time >= SimulationProcess.CurrentTime())) {
                throw new SimulationException("Time " + time + " invalid.");
            }
        } else {
            throw new SimulationException("SimulationProcess is not idle.");
        }
        this.wakeuptime = time;
    }

    protected void Hold(double t) throws SimulationException, RestartException {
        if (this != Current && Current != null) {
            throw new SimulationException("Hold applied to inactive object.");
        }
        this.wakeuptime = -1.0;
        this.ActivateDelay(t, false);
        this.Suspend();
    }

    protected void Passivate() throws RestartException {
        if (!this.Passivated && this == Current) {
            this.Cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Suspend() throws RestartException {
        block9: {
            try {
                if (!Scheduler.schedule()) break block9;
                Object object = this.mutex;
                synchronized (object) {
                    --this.count;
                    if (this.count == 0) {
                        try {
                            this.mutex.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (SimulationException simulationException) {
                // empty catch block
            }
        }
        if (Scheduler.simulationReset()) {
            throw new RestartException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Resume() {
        if (Current == null) {
            Current = this;
            this.wakeuptime = SimulationProcess.CurrentTime();
        }
        if (!this.Terminated) {
            if (!this.started) {
                this.started = true;
                this.start();
            } else {
                Object object = this.mutex;
                synchronized (object) {
                    ++this.count;
                    if (this.count >= 0) {
                        this.mutex.notify();
                    }
                }
            }
        }
    }

    private boolean checkTime(double time) {
        return time >= 0.0;
    }

    void passivate() {
        this.Passivated = true;
        this.wakeuptime = -1.0;
    }
}

