/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Simulation;

import arjuna.JavaSim.Simulation.RestartException;
import arjuna.JavaSim.Simulation.SimulationEntity;
import arjuna.JavaSim.Simulation.SimulationEntityList;
import arjuna.JavaSim.Simulation.SimulationException;
import arjuna.JavaSim.Simulation.SimulationProcess;
import java.util.NoSuchElementException;

public class TriggerQueue {
    private SimulationEntityList head = new SimulationEntityList();
    private long numberOfElements;

    public void finalize() {
        if (this.head != null && this.head.numberOfElements() > 0L) {
            System.out.println("TriggerQueue destructor called with non-zero list!");
            try {
                this.triggerAll();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public synchronized void triggerFirst(boolean setTrigger) throws NoSuchElementException {
        if (this.head.numberOfElements() == 0L) {
            throw new NoSuchElementException();
        }
        SimulationEntity removed = this.remove();
        if (setTrigger) {
            removed.trigger();
        }
        try {
            removed.ReActivateAt(SimulationProcess.CurrentTime());
        }
        catch (RestartException e) {
        }
        catch (SimulationException simulationException) {
            // empty catch block
        }
    }

    public synchronized void triggerFirst() throws NoSuchElementException {
        this.triggerFirst(true);
    }

    public synchronized void triggerAll() throws NoSuchElementException {
        long currentNumber = this.head.numberOfElements();
        if (currentNumber == 0L) {
            throw new NoSuchElementException();
        }
        int i = 0;
        while ((long)i < currentNumber) {
            this.triggerFirst();
            ++i;
        }
    }

    protected synchronized void insert(SimulationEntity toAdd) throws SimulationException {
        if (toAdd._isWaiting != null) {
            throw new SimulationException("Entity already waiting on event.");
        }
        this.head.add(toAdd);
    }

    protected synchronized SimulationEntity remove() throws NoSuchElementException {
        return this.head.removeFirst();
    }
}

