/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Statistics;

import arjuna.JavaSim.Statistics.Bucket;
import arjuna.JavaSim.Statistics.PrecisionHistogram;
import arjuna.JavaSim.Statistics.StatisticsException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Histogram
extends PrecisionHistogram {
    public static final int ACCUMULATE = 0;
    public static final int MEAN = 1;
    public static final int MAX = 2;
    public static final int MIN = 3;
    protected long maxSize;
    protected int merge;

    public Histogram(long maxIndex, int mergeChoice) {
        this.maxSize = maxIndex > 0L ? maxIndex : 2L;
        this.merge = mergeChoice;
    }

    public Histogram(long maxIndex) {
        this.maxSize = maxIndex > 0L ? maxIndex : 2L;
        this.merge = 1;
    }

    public void setValue(double value) throws IllegalArgumentException {
        if (this.numberOfBuckets() == this.maxSize && !this.isPresent(value)) {
            try {
                this.mergeBuckets();
            }
            catch (StatisticsException statisticsException) {
                // empty catch block
            }
        }
        super.setValue(value);
    }

    public boolean saveState(String fileName) throws IOException {
        FileOutputStream f = new FileOutputStream(fileName);
        DataOutputStream iFile = new DataOutputStream(f);
        boolean res = this.saveState(iFile);
        f.close();
        return res;
    }

    public boolean saveState(DataOutputStream oFile) throws IOException {
        oFile.writeLong(this.maxSize);
        oFile.writeInt(this.merge);
        return super.saveState(oFile);
    }

    public boolean restoreState(String fileName) throws FileNotFoundException, IOException {
        FileInputStream f = new FileInputStream(fileName);
        DataInputStream oFile = new DataInputStream(f);
        boolean res = this.restoreState(oFile);
        f.close();
        return res;
    }

    public boolean restoreState(DataInputStream iFile) throws IOException {
        this.maxSize = iFile.readLong();
        this.merge = iFile.readInt();
        return super.restoreState(iFile);
    }

    public void print() {
        System.out.println("Maximum number of buckets " + this.maxSize);
        System.out.print("Merge choice is ");
        switch (this.merge) {
            case 0: {
                System.out.println("ACCUMULATE");
                break;
            }
            case 1: {
                System.out.println("MEAN");
                break;
            }
            case 2: {
                System.out.println("MAX");
                break;
            }
            case 3: {
                System.out.println("MIN");
            }
        }
        super.print();
    }

    protected void mergeBuckets() throws StatisticsException {
        Bucket newHead = null;
        Bucket ptr = null;
        Bucket index = this.Head;
        long newLength = 0L;
        index = this.Head;
        while (index != null) {
            Bucket newElement = null;
            if (index.cdr() != null) {
                newElement = new Bucket(this.compositeName(index, index.cdr()));
                newElement.size(this.compositeSize(index, index.cdr()));
                index = index.cdr().cdr();
            } else {
                newElement = new Bucket(index);
            }
            ++newLength;
            if (newHead != null) {
                ptr.setCdr(newElement);
            } else {
                newHead = newElement;
            }
            ptr = newElement;
        }
        ptr = index = this.Head;
        while (index != null) {
            index = ptr = index.cdr();
        }
        this.Head = newHead;
        this.length = newLength;
    }

    private double compositeName(Bucket a, Bucket b) {
        switch (this.merge) {
            case 0: 
            case 2: {
                return b.Name();
            }
            case 1: {
                return (a.Name() * (double)a.size() + b.Name() * (double)b.size()) / (double)(a.size() + b.size());
            }
            case 3: {
                return a.Name();
            }
        }
        return 0.0;
    }

    private long compositeSize(Bucket a, Bucket b) throws StatisticsException {
        switch (this.merge) {
            case 0: {
                return a.size() + b.size();
            }
            case 1: {
                return a.size() + b.size();
            }
            case 2: {
                return b.size();
            }
            case 3: {
                return a.size();
            }
        }
        throw new StatisticsException("compositeSize switch error.");
    }
}

