/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Statistics;

import arjuna.JavaSim.Simulation.SimulationProcess;
import arjuna.JavaSim.Statistics.Variance;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TimeVariance
extends Variance {
    private boolean first;
    private double startTime;
    private double currentValue;
    private double stime;
    private double total;

    public TimeVariance() {
        this.reset();
    }

    public void reset() {
        this.first = true;
        this.currentValue = 0.0;
        this.startTime = 0.0;
        this.total = 0.0;
        this.stime = 0.0;
        super.reset();
    }

    public void setValue(double value) throws IllegalArgumentException {
        super.setValue(value);
        if (!this.first) {
            this.total += this.area();
            if (value == this.currentValue) {
                return;
            }
        } else {
            this.first = false;
            this.startTime = SimulationProcess.CurrentTime();
        }
        this.store(value);
    }

    public double timeAverage() {
        if (this.first || SimulationProcess.CurrentTime() - this.startTime == 0.0) {
            return 0.0;
        }
        return (this.total + this.area()) / (SimulationProcess.CurrentTime() - this.startTime);
    }

    public boolean saveState(String fileName) throws IOException {
        FileOutputStream f = new FileOutputStream(fileName);
        DataOutputStream oFile = new DataOutputStream(f);
        boolean res = this.saveState(oFile);
        f.close();
        return res;
    }

    public boolean saveState(DataOutputStream oFile) throws IOException {
        oFile.writeBoolean(this.first);
        oFile.writeDouble(this.startTime);
        oFile.writeDouble(this.currentValue);
        oFile.writeDouble(this.stime);
        oFile.writeDouble(this.total);
        return super.saveState(oFile);
    }

    public boolean restoreState(String fileName) throws FileNotFoundException, IOException {
        FileInputStream f = new FileInputStream(fileName);
        DataInputStream iFile = new DataInputStream(f);
        boolean res = this.restoreState(iFile);
        f.close();
        return res;
    }

    public boolean restoreState(DataInputStream iFile) throws IOException {
        this.first = iFile.readBoolean();
        this.startTime = iFile.readDouble();
        this.currentValue = iFile.readDouble();
        this.stime = iFile.readDouble();
        this.total = iFile.readDouble();
        return true;
    }

    private double area() {
        return this.currentValue * (SimulationProcess.CurrentTime() - this.stime);
    }

    private void store(double value) {
        this.currentValue = value;
        this.stime = SimulationProcess.CurrentTime();
    }
}

