/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.util.FacesLogger;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExceptionHandler;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionEvent;
import javax.faces.event.ExceptionEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private static final String LOG_BEFORE_KEY = "jsf.context.exception.handler.log_before";
    private static final String LOG_AFTER_KEY = "jsf.context.exception.handler.log_after";
    private static final String LOG_KEY = "jsf.context.exception.handler.log";
    private LinkedList<ExceptionEvent> unhandledExceptions;
    private LinkedList<ExceptionEvent> handledExceptions;
    private ExceptionEvent handled;

    public ExceptionEvent getHandledExceptionEvent() {
        return this.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        Iterator<ExceptionEvent> i = this.getUnhandledExceptionEvents().iterator();
        while (i.hasNext()) {
            ExceptionEvent event = i.next();
            ExceptionEventContext context = (ExceptionEventContext)event.getSource();
            try {
                Throwable t = context.getException();
                if (this.isRethrown(t)) {
                    this.handled = event;
                    Throwable unwrapped = this.getRootCause(t);
                    if (unwrapped != null) {
                        throw new FacesException(unwrapped.getMessage(), unwrapped);
                    }
                    if (t instanceof FacesException) {
                        throw (FacesException)t;
                    }
                    throw new FacesException(t.getMessage(), t);
                }
                this.log(context);
            }
            finally {
                if (this.handledExceptions == null) {
                    this.handledExceptions = new LinkedList();
                }
                this.handledExceptions.add(event);
                i.remove();
            }
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof ExceptionEventContext;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event != null) {
            if (this.unhandledExceptions == null) {
                this.unhandledExceptions = new LinkedList();
            }
            this.unhandledExceptions.add((ExceptionEvent)event);
        }
    }

    public Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        if (this.shouldUnwrap(t.getClass())) {
            Throwable root = t.getCause();
            if (root != null) {
                Throwable tmp = this.getRootCause(root);
                if (tmp == null) {
                    return root;
                }
                return tmp;
            }
            return t;
        }
        return t;
    }

    public Iterable<ExceptionEvent> getUnhandledExceptionEvents() {
        return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
    }

    public Iterable<ExceptionEvent> getHandledExceptionEvents() {
        return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
    }

    private boolean shouldUnwrap(Class<? extends Throwable> c) {
        return FacesException.class.equals(c) || ELException.class.equals(c);
    }

    private boolean isRethrown(Throwable t) {
        return !(t instanceof AbortProcessingException);
    }

    private void log(ExceptionEventContext exceptionContext) {
        UIComponent c = exceptionContext.getComponent();
        boolean beforePhase = exceptionContext.inBeforePhase();
        boolean afterPhase = exceptionContext.inAfterPhase();
        PhaseId phaseId = exceptionContext.getPhaseId();
        Throwable t = exceptionContext.getException();
        String key = this.getLoggingKey(beforePhase, afterPhase);
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, key, new Object[]{t.getClass().getName(), phaseId.toString(), c != null ? c.getClientId(exceptionContext.getContext()) : "", t.getMessage()});
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private String getLoggingKey(boolean beforePhase, boolean afterPhase) {
        if (beforePhase) {
            return LOG_BEFORE_KEY;
        }
        if (afterPhase) {
            return LOG_AFTER_KEY;
        }
        return LOG_KEY;
    }
}

