/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.AjaxBehavior;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class ButtonRenderer
extends HtmlBasicRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.COMMANDBUTTON);

    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        if (ButtonRenderer.wasClicked(context, component) && !ButtonRenderer.isReset(component)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This command resulted in form submission  ActionEvent queued.");
                logger.log(Level.FINE, "End decoding component {0}", component.getId());
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        boolean hasParams;
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        String type = ButtonRenderer.getButtonType(component);
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String label = "";
        Object value = ((UICommand)component).getValue();
        if (value != null) {
            label = value.toString();
        }
        Object[] params = this.getParamList(component);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)component.getAttributes().get("javax.faces.component.AjaxBehavior");
        boolean bl = hasParams = !Arrays.equals(params, EMPTY_PARAMS);
        if (hasParams && (type.equals("submit") || type.equals("button"))) {
            RenderKitUtils.renderJsfJs(context);
        }
        String imageSrc = (String)component.getAttributes().get("image");
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String clientId = component.getClientId(context);
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            writer.writeURIAttribute("src", (Object)ButtonRenderer.src(context, imageSrc), "image");
            writer.writeAttribute("name", (Object)clientId, "clientId");
        } else {
            writer.writeAttribute("type", (Object)type, "type");
            writer.writeAttribute("name", (Object)clientId, "clientId");
            writer.writeAttribute("value", (Object)label, "value");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        RenderKitUtils.renderOnclick(context, component, (HtmlBasicRenderer.Param[])params, ajaxBehavior);
        writer.endElement("input");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    private static String src(FacesContext context, String imageURI) {
        if (imageURI == null) {
            return "";
        }
        String u = context.getApplication().getViewHandler().getResourceURL(context, imageURI);
        return context.getExternalContext().encodeResourceURL(u);
    }

    private static boolean wasClicked(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.get(clientId) == null) {
            StringBuilder builder = new StringBuilder(clientId);
            String xValue = builder.append(".x").toString();
            builder.setLength(clientId.length());
            String yValue = builder.append(".y").toString();
            return requestParameterMap.get(xValue) != null && requestParameterMap.get(yValue) != null;
        }
        return true;
    }

    private static boolean isReset(UIComponent component) {
        return "reset".equals(component.getAttributes().get("type"));
    }

    private static String getButtonType(UIComponent component) {
        String type = (String)component.getAttributes().get("type");
        if (type == null || !"reset".equals(type) && !"submit".equals(type) && !"button".equals(type)) {
            type = "submit";
            component.getAttributes().put("type", type);
        }
        return type;
    }
}

