/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private Map<String, Set<NavigationCase>> navigationMap;
    private Set<String> wildCardSet;
    private boolean navigationConfigured;
    private boolean development;
    private static final Pattern REDIRECT_EQUALS_TRUE = Pattern.compile("(?:\\?|&)(redirect=true(&|$))");

    public NavigationHandlerImpl() {
        ApplicationAssociate associate;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        if ((associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext())) != null) {
            this.navigationMap = associate.getNavigationCaseListMappings();
            this.wildCardSet = associate.getNavigationWildCardList();
            this.navigationConfigured = this.wildCardSet != null && this.navigationMap != null;
            this.development = associate.isDevModeEnabled();
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        NavigationCase result = null;
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome);
        if (null != caseStruct) {
            result = caseStruct.navCase;
        }
        return result;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.navigationMap;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome);
        if (caseStruct != null) {
            ExternalContext extContext = context.getExternalContext();
            ViewHandler viewHandler = Util.getViewHandler(context);
            assert (null != viewHandler);
            if (caseStruct.navCase.isRedirect()) {
                String newPath = viewHandler.getActionURL(context, caseStruct.viewId);
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Redirecting to path " + newPath + " for outcome " + outcome + "and viewId " + caseStruct.viewId);
                    }
                    context.getFlash().setRedirect(true);
                    extContext.redirect(extContext.encodeActionURL(newPath));
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "jsf.redirect_failed_error", newPath);
                    }
                    throw new FacesException(ioe.getMessage(), (Throwable)ioe);
                }
                context.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                context.setViewRoot(newRoot);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private CaseStruct getViewId(FacesContext ctx, String fromAction, String outcome) {
        UIViewRoot root = ctx.getViewRoot();
        String viewId = root != null ? root.getViewId() : null;
        CaseStruct caseStruct = null;
        if (viewId != null && (caseStruct = this.findExactMatch(ctx, viewId, fromAction, outcome)) == null) {
            caseStruct = this.findWildCardMatch(ctx, viewId, fromAction, outcome);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(ctx, fromAction, outcome);
        }
        if (caseStruct == null && outcome != null) {
            caseStruct = this.findImplicitMatch(ctx, root, fromAction, outcome);
        }
        if (caseStruct == null && outcome != null && this.development) {
            Object[] params;
            String key;
            if (fromAction == null) {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME";
                params = new Object[]{viewId, outcome};
            } else {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME_ACTION";
                params = new Object[]{viewId, fromAction, outcome};
            }
            FacesMessage m = MessageUtils.getExceptionMessage(key, params);
            m.setSeverity(FacesMessage.SEVERITY_WARN);
            ctx.addMessage(null, m);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(FacesContext ctx, String viewId, String fromAction, String outcome) {
        if (!this.navigationConfigured) {
            return null;
        }
        Set<NavigationCase> caseSet = this.navigationMap.get(viewId);
        if (caseSet == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome);
    }

    private CaseStruct findWildCardMatch(FacesContext ctx, String viewId, String fromAction, String outcome) {
        CaseStruct result = null;
        if (!this.navigationConfigured) {
            return null;
        }
        for (String fromViewId : this.wildCardSet) {
            if (!viewId.startsWith(fromViewId)) continue;
            String wcFromViewId = new StringBuilder(32).append(fromViewId).append('*').toString();
            Set<NavigationCase> ccaseSet = this.navigationMap.get(wcFromViewId);
            if (ccaseSet == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(ctx, ccaseSet, fromAction, outcome);
            if (result == null) continue;
            break;
        }
        return result;
    }

    private CaseStruct findDefaultMatch(FacesContext ctx, String fromAction, String outcome) {
        if (!this.navigationConfigured) {
            return null;
        }
        Set<NavigationCase> caseSet = this.navigationMap.get("*");
        if (caseSet == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome);
    }

    private CaseStruct findImplicitMatch(FacesContext context, UIViewRoot root, String fromAction, String outcome) {
        int idx;
        String viewIdToTest = outcome;
        String currentViewId = root.getViewId();
        boolean isRedirect = false;
        int questionMark = viewIdToTest.indexOf(63);
        String queryString = null;
        if (-1 != questionMark) {
            queryString = viewIdToTest.substring(questionMark);
            viewIdToTest = viewIdToTest.substring(0, questionMark);
            Matcher m = REDIRECT_EQUALS_TRUE.matcher(queryString);
            if (m.find()) {
                isRedirect = true;
                queryString = queryString.replace(m.group(1), "");
            }
            if (queryString.endsWith("&")) {
                queryString = queryString.substring(0, queryString.length() - 1);
            }
        }
        if (viewIdToTest.lastIndexOf(46) == -1 && (idx = currentViewId.lastIndexOf(46)) != -1) {
            viewIdToTest = viewIdToTest + currentViewId.substring(idx);
        }
        if (!viewIdToTest.startsWith("/")) {
            int lastSlash = currentViewId.lastIndexOf("/");
            if (lastSlash != -1) {
                currentViewId = currentViewId.substring(0, lastSlash + 1);
                viewIdToTest = currentViewId + viewIdToTest;
            } else {
                viewIdToTest = "/" + viewIdToTest;
            }
        }
        ViewHandler viewHandler = Util.getViewHandler(context);
        try {
            viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest);
        }
        catch (UnsupportedOperationException e) {
            viewIdToTest = Util.deriveViewId(context, viewIdToTest);
        }
        if (null != viewIdToTest) {
            CaseStruct caseStruct = new CaseStruct();
            if (isRedirect && queryString != null) {
                viewIdToTest = viewIdToTest + queryString;
            }
            caseStruct.viewId = viewIdToTest;
            caseStruct.navCase = new NavigationCase(currentViewId, fromAction, outcome, null, viewIdToTest, isRedirect);
            return caseStruct;
        }
        return null;
    }

    private CaseStruct determineViewFromActionOutcome(FacesContext ctx, Set<NavigationCase> caseSet, String fromAction, String outcome) {
        CaseStruct result = new CaseStruct();
        boolean match = false;
        for (NavigationCase cnc : caseSet) {
            String cncFromAction = cnc.getFromAction();
            String cncFromOutcome = cnc.getFromOutcome();
            boolean cncHasCondition = cnc.hasCondition();
            String cncToViewId = cnc.getToViewId(ctx);
            if (cncToViewId.charAt(0) != '/') {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "jsf.config.navigation.to_view_id_leading_slash", new String[]{cncToViewId, cnc.getFromViewId()});
                }
                cncToViewId = '/' + cncToViewId;
            }
            if (cncFromAction != null && cncFromOutcome != null) {
                if (cncFromAction.equals(fromAction) && cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome != null) {
                if (cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction != null && cncFromOutcome == null) {
                if (cncFromAction.equals(fromAction) && (outcome != null || cncHasCondition)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome == null && (outcome != null || cncHasCondition)) {
                result.viewId = cncToViewId;
                result.navCase = cnc;
                match = true;
            }
            if (!match) continue;
            if (cncHasCondition && Boolean.FALSE.equals(cnc.getCondition(ctx))) {
                match = false;
                continue;
            }
            return result;
        }
        return null;
    }

    private static class CaseStruct {
        String viewId;
        NavigationCase navCase;

        private CaseStruct() {
        }
    }
}

